/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ConditionalModule;
import com.facebook.presto.hive.HiveClientModule;
import com.facebook.presto.hive.HiveConnector;
import com.facebook.presto.hive.HiveHandleResolver;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.NoSecurityModule;
import com.facebook.presto.hive.ReadOnlySecurityModule;
import com.facebook.presto.hive.RebindSafeMBeanServer;
import com.facebook.presto.hive.SecurityConfig;
import com.facebook.presto.hive.SqlStandardSecurityModule;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeNodePartitioningProvider;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.json.JsonModule;
import io.airlift.node.NodeModule;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;

public class HiveConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Map<String, String> optionalConfig;
    private final ClassLoader classLoader;
    private final HiveMetastore metastore;
    private final TypeManager typeManager;
    private final PageIndexerFactory pageIndexerFactory;
    private final NodeManager nodeManager;

    public HiveConnectorFactory(String name, Map<String, String> optionalConfig, ClassLoader classLoader, HiveMetastore metastore, TypeManager typeManager, PageIndexerFactory pageIndexerFactory, NodeManager nodeManager) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.optionalConfig = Objects.requireNonNull(optionalConfig, "optionalConfig is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.metastore = metastore;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexer is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new HiveHandleResolver();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector create(String connectorId, Map<String, String> config) {
        Objects.requireNonNull(config, "config is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new NodeModule(), new MBeanModule(), new JsonModule(), new HiveClientModule(connectorId, this.metastore, this.typeManager, this.pageIndexerFactory, this.nodeManager), ConditionalModule.installModuleIf(SecurityConfig.class, security -> "allow-all".equalsIgnoreCase(security.getSecuritySystem()), new NoSecurityModule()), ConditionalModule.installModuleIf(SecurityConfig.class, security -> "read-only".equalsIgnoreCase(security.getSecuritySystem()), new ReadOnlySecurityModule()), ConditionalModule.installModuleIf(SecurityConfig.class, security -> "sql-standard".equalsIgnoreCase(security.getSecuritySystem()), new SqlStandardSecurityModule()), binder -> {
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                binder.bind(MBeanServer.class).toInstance((Object)new RebindSafeMBeanServer(platformMBeanServer));
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            HiveMetadataFactory metadataFactory = (HiveMetadataFactory)injector.getInstance(HiveMetadataFactory.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            HiveSessionProperties hiveSessionProperties = (HiveSessionProperties)injector.getInstance(HiveSessionProperties.class);
            HiveTableProperties hiveTableProperties = (HiveTableProperties)injector.getInstance(HiveTableProperties.class);
            ConnectorAccessControl accessControl = (ConnectorAccessControl)injector.getInstance(ConnectorAccessControl.class);
            HiveConnector hiveConnector = new HiveConnector(lifeCycleManager, metadataFactory, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, this.classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, this.classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, this.classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, this.classLoader), (Set<SystemTable>)ImmutableSet.of(), hiveSessionProperties.getSessionProperties(), hiveTableProperties.getTableProperties(), accessControl, this.classLoader);
            return hiveConnector;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

