/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;

public enum HiveErrorCode implements ErrorCodeSupplier
{
    HIVE_METASTORE_ERROR(0x1000000),
    HIVE_CURSOR_ERROR(0x1000001),
    HIVE_TABLE_OFFLINE(0x1000002),
    HIVE_CANNOT_OPEN_SPLIT(0x1000003),
    HIVE_FILE_NOT_FOUND(0x1000004),
    HIVE_UNKNOWN_ERROR(0x1000005),
    HIVE_PARTITION_OFFLINE(0x1000006),
    HIVE_BAD_DATA(0x1000007),
    HIVE_PARTITION_SCHEMA_MISMATCH(0x1000008),
    HIVE_MISSING_DATA(0x1000009),
    HIVE_INVALID_PARTITION_VALUE(0x100000A),
    HIVE_TIMEZONE_MISMATCH(0x100000B),
    HIVE_INVALID_METADATA(0x100000C),
    HIVE_INVALID_VIEW_DATA(0x100000D),
    HIVE_DATABASE_LOCATION_ERROR(0x100000E),
    HIVE_PATH_ALREADY_EXISTS(0x100000F),
    HIVE_FILESYSTEM_ERROR(0x1000010),
    HIVE_SERDE_NOT_FOUND(0x1000012),
    HIVE_UNSUPPORTED_FORMAT(0x1000013),
    HIVE_PARTITION_READ_ONLY(0x10000014),
    HIVE_TOO_MANY_OPEN_PARTITIONS(0x1000015),
    HIVE_CONCURRENT_MODIFICATION_DETECTED(0x1000016),
    HIVE_COLUMN_ORDER_MISMATCH(0x1000017),
    HIVE_FILE_MISSING_COLUMN_NAMES(0x1000018),
    HIVE_WRITER_OPEN_ERROR(0x1000019),
    HIVE_WRITER_CLOSE_ERROR(0x100001A),
    HIVE_WRITER_DATA_ERROR(0x100001B);

    private final ErrorCode errorCode;

    private HiveErrorCode(int code) {
        this.errorCode = new ErrorCode(code, this.name());
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }
}

