/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.ThriftHiveMetastoreClient;
import com.facebook.presto.hive.metastore.HiveMetastoreClient;
import com.facebook.presto.hive.thrift.Transport;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import io.airlift.units.Duration;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.thrift.transport.TTransportException;

public class HiveMetastoreClientFactory {
    private final HostAndPort socksProxy;
    private final int timeoutMillis;

    public HiveMetastoreClientFactory(@Nullable HostAndPort socksProxy, Duration timeout) {
        this.socksProxy = socksProxy;
        this.timeoutMillis = Ints.checkedCast((long)timeout.toMillis());
    }

    @Inject
    public HiveMetastoreClientFactory(HiveClientConfig config) {
        this(config.getMetastoreSocksProxy(), config.getMetastoreTimeout());
    }

    public HiveMetastoreClient create(String host, int port) throws TTransportException {
        return new ThriftHiveMetastoreClient(Transport.create(host, port, this.socksProxy, this.timeoutMillis));
    }
}

