/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.metastore.HivePrivilege;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class SqlStandardAccessControl
implements ConnectorAccessControl {
    private static final String ADMIN_ROLE_NAME = "admin";
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final String connectorId;
    private final HiveMetastore metastore;
    private final boolean allowDropTable;
    private final boolean allowRenameTable;

    @Inject
    public SqlStandardAccessControl(HiveConnectorId connectorId, HiveMetastore metastore, HiveClientConfig hiveClientConfig) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        this.allowDropTable = hiveClientConfig.getAllowDropTable();
        this.allowRenameTable = hiveClientConfig.getAllowRenameTable();
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkDatabasePermission(identity, tableName.getSchemaName(), HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.allowDropTable || !this.checkTablePermission(identity, tableName, HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.allowRenameTable || !this.checkTablePermission(identity, tableName, HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, HivePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, HivePrivilege.INSERT)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, HivePrivilege.DELETE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanCreateView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkDatabasePermission(identity, viewName.getSchemaName(), HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanDropView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkTablePermission(identity, viewName, HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkTablePermission(identity, viewName, HivePrivilege.SELECT)) {
            AccessDeniedException.denySelectView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, HivePrivilege.SELECT, HivePrivilege.GRANT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkTablePermission(identity, viewName, HivePrivilege.SELECT, HivePrivilege.GRANT)) {
            AccessDeniedException.denySelectView((String)viewName.toString());
        }
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, String propertyName) {
        if (!this.metastore.getRoles(identity.getUser()).contains(ADMIN_ROLE_NAME)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)this.connectorId, (String)propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(Identity identity, Privilege privilege, SchemaTableName tableName) {
        if (this.checkTablePermission(identity, tableName, HivePrivilege.OWNERSHIP)) {
            return;
        }
        HivePrivilege hivePrivilege = HivePrivilege.toHivePrivilege(privilege);
        if (hivePrivilege == null || !this.metastore.hasPrivilegeWithGrantOptionOnTable(identity.getUser(), tableName.getSchemaName(), tableName.getTableName(), hivePrivilege)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    private boolean checkDatabasePermission(Identity identity, String schemaName, HivePrivilege ... requiredPrivileges) {
        Set<HivePrivilege> privilegeSet = this.metastore.getDatabasePrivileges(identity.getUser(), schemaName);
        return privilegeSet.containsAll((Collection<?>)ImmutableSet.copyOf((Object[])requiredPrivileges));
    }

    private boolean checkTablePermission(Identity identity, SchemaTableName tableName, HivePrivilege ... requiredPrivileges) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        Set<HivePrivilege> privilegeSet = this.metastore.getTablePrivileges(identity.getUser(), tableName.getSchemaName(), tableName.getTableName());
        return privilegeSet.containsAll((Collection<?>)ImmutableSet.copyOf((Object[])requiredPrivileges));
    }
}

