/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.tpch.TpchHandleResolver;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchNodePartitioningProvider;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchSplitManager;
import com.facebook.presto.tpch.TpchTransactionHandle;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;

public class TpchConnectorFactory
implements ConnectorFactory {
    private final NodeManager nodeManager;
    private final int defaultSplitsPerNode;

    public TpchConnectorFactory(NodeManager nodeManager) {
        this(nodeManager, Runtime.getRuntime().availableProcessors());
    }

    public TpchConnectorFactory(NodeManager nodeManager, int defaultSplitsPerNode) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
    }

    public String getName() {
        return "tpch";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpchHandleResolver();
    }

    public Connector create(final String connectorId, Map<String, String> properties) {
        final int splitsPerNode = this.getSplitsPerNode(properties);
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return TpchTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return new TpchMetadata(connectorId);
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(connectorId, TpchConnectorFactory.this.nodeManager, splitsPerNode);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpchRecordSetProvider();
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpchNodePartitioningProvider(connectorId, TpchConnectorFactory.this.nodeManager, splitsPerNode);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }
}

