/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.tpch.TpchBucketFunction;
import com.facebook.presto.tpch.TpchPartitioningHandle;
import com.facebook.presto.tpch.TpchSplit;
import com.facebook.presto.tpch.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;

public class TpchNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final String connectorId;
    private final NodeManager nodeManager;
    private final int splitsPerNode;

    public TpchNodePartitioningProvider(String connectorId, NodeManager nodeManager, int splitsPerNode) {
        this.connectorId = connectorId;
        this.nodeManager = nodeManager;
        Preconditions.checkArgument((splitsPerNode > 0 ? 1 : 0) != 0, (Object)"splitsPerNode must be at least 1");
        this.splitsPerNode = splitsPerNode;
    }

    public Map<Integer, Node> getBucketToNode(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        Set nodes = this.nodeManager.getActiveDatasourceNodes(this.connectorId);
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No TPCH nodes available");
        ImmutableMap.Builder bucketToNode = ImmutableMap.builder();
        int partNumber = 0;
        for (Node node : nodes) {
            for (int i = 0; i < this.splitsPerNode; ++i) {
                bucketToNode.put((Object)partNumber, (Object)node);
                ++partNumber;
            }
        }
        return bucketToNode.build();
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> Types.checkType(value, TpchSplit.class, "value").getPartNumber();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        long totalRows = Types.checkType(partitioningHandle, TpchPartitioningHandle.class, "functionHandle").getTotalRows();
        long rowsPerBucket = totalRows / (long)bucketCount;
        Preconditions.checkArgument((boolean)partitionChannelTypes.equals(ImmutableList.of((Object)BigintType.BIGINT)), (Object)"Expected one BIGINT parameter");
        return new TpchBucketFunction(bucketCount, rowsPerBucket);
    }
}

