/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis.decoder.hash;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Set;

public class HashRedisFieldDecoder
implements FieldDecoder<String> {
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
    }

    public String getRowDecoderName() {
        return "hash";
    }

    public String getFieldDecoderName() {
        return "_default";
    }

    public FieldValueProvider decode(final String value, final DecoderColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        return new FieldValueProvider(){

            public boolean accept(DecoderColumnHandle handle) {
                return columnHandle.equals(handle);
            }

            public boolean isNull() {
                return value == null || value.isEmpty();
            }

            public boolean getBoolean() {
                return this.isNull() ? false : Boolean.parseBoolean(value.trim());
            }

            public long getLong() {
                return this.isNull() ? 0L : Long.parseLong(value.trim());
            }

            public double getDouble() {
                return this.isNull() ? 0.0 : Double.parseDouble(value.trim());
            }

            public Slice getSlice() {
                return this.isNull() ? Slices.EMPTY_SLICE : Slices.utf8Slice((String)value);
            }
        };
    }

    public String toString() {
        return String.format("FieldDecoder[%s/%s]", this.getRowDecoderName(), this.getFieldDecoderName());
    }
}

