/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis.decoder.hash;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.RowDecoder;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HashRedisRowDecoder
implements RowDecoder {
    public static final String NAME = "hash";

    public String getName() {
        return NAME;
    }

    public boolean decodeRow(byte[] data, Map<String, String> dataMap, Set<FieldValueProvider> fieldValueProviders, List<DecoderColumnHandle> columnHandles, Map<DecoderColumnHandle, FieldDecoder<?>> fieldDecoders) {
        if (dataMap == null) {
            return false;
        }
        for (DecoderColumnHandle columnHandle : columnHandles) {
            if (columnHandle.isInternal()) continue;
            String mapping = columnHandle.getMapping();
            Preconditions.checkState((mapping != null ? 1 : 0) != 0, (String)"No mapping for column handle %s!", (Object[])new Object[]{columnHandle});
            String valueField = dataMap.get(mapping);
            FieldDecoder<?> decoder = fieldDecoders.get(columnHandle);
            if (decoder == null) continue;
            fieldValueProviders.add(decoder.decode((Object)valueField, columnHandle));
        }
        return false;
    }
}

