/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class VectorCoalesce
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int[] inputColumns;
    private int outputColumn;

    public VectorCoalesce(int[] inputColumns, int outputColumn) {
        this();
        this.inputColumns = inputColumns;
        this.outputColumn = outputColumn;
    }

    public VectorCoalesce() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        int[] sel = batch.selected;
        int n = batch.size;
        ColumnVector outputVector = batch.cols[this.outputColumn];
        if (n <= 0) {
            return;
        }
        outputVector.init();
        outputVector.noNulls = false;
        outputVector.isRepeating = false;
        if (batch.selectedInUse) {
            block0: for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector.isNull[i] = true;
                for (int k = 0; k < this.inputColumns.length; ++k) {
                    ColumnVector cv = batch.cols[this.inputColumns[k]];
                    if (cv.isRepeating && (cv.noNulls || !cv.isNull[0])) {
                        outputVector.isNull[i] = false;
                        outputVector.setElement(i, 0, cv);
                        continue block0;
                    }
                    if (cv.isRepeating || !cv.noNulls && cv.isNull[i]) continue;
                    outputVector.isNull[i] = false;
                    outputVector.setElement(i, i, cv);
                    continue block0;
                }
            }
        } else {
            block2: for (int i = 0; i != n; ++i) {
                outputVector.isNull[i] = true;
                for (int k = 0; k < this.inputColumns.length; ++k) {
                    ColumnVector cv = batch.cols[this.inputColumns[k]];
                    if (cv.isRepeating && (cv.noNulls || !cv.isNull[0])) {
                        outputVector.isNull[i] = false;
                        outputVector.setElement(i, 0, cv);
                        continue block2;
                    }
                    if (cv.isRepeating || !cv.noNulls && cv.isNull[i]) continue;
                    outputVector.isNull[i] = false;
                    outputVector.setElement(i, i, cv);
                    continue block2;
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return this.outputType;
    }

    public int[] getInputColumns() {
        return this.inputColumns;
    }

    public void setInputColumns(int[] inputColumns) {
        this.inputColumns = inputColumns;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        throw new UnsupportedOperationException("Undefined descriptor");
    }
}

