/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.plugin.blackhole.BlackHoleColumnHandle;
import com.facebook.presto.plugin.blackhole.BlackHoleInsertTableHandle;
import com.facebook.presto.plugin.blackhole.BlackHoleOutputTableHandle;
import com.facebook.presto.plugin.blackhole.BlackHolePartitioningHandle;
import com.facebook.presto.plugin.blackhole.BlackHoleTableHandle;
import com.facebook.presto.plugin.blackhole.BlackHoleTableLayoutHandle;
import com.facebook.presto.plugin.blackhole.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.slice.Slice;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class BlackHoleMetadata
implements ConnectorMetadata {
    public static final String SCHEMA_NAME = "default";
    private final Map<String, BlackHoleTableHandle> tables = new ConcurrentHashMap<String, BlackHoleTableHandle>();

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)SCHEMA_NAME);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.tables.get(tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = Types.checkType(tableHandle, BlackHoleTableHandle.class, "tableHandle");
        return blackHoleTableHandle.toTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull != null && !schemaNameOrNull.equals(SCHEMA_NAME)) {
            return ImmutableList.of();
        }
        return this.tables.values().stream().map(BlackHoleTableHandle::toSchemaTableName).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = Types.checkType(tableHandle, BlackHoleTableHandle.class, "tableHandle");
        return blackHoleTableHandle.getColumnHandles().stream().collect(Collectors.toMap(BlackHoleColumnHandle::getName, column -> column));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        BlackHoleColumnHandle blackHoleColumnHandle = Types.checkType(columnHandle, BlackHoleColumnHandle.class, "columnHandle");
        return blackHoleColumnHandle.toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return this.tables.values().stream().filter(table -> prefix.matches(table.toSchemaTableName())).collect(Collectors.toMap(BlackHoleTableHandle::toSchemaTableName, handle -> handle.toTableMetadata().getColumns()));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = Types.checkType(tableHandle, BlackHoleTableHandle.class, "tableHandle");
        this.tables.remove(blackHoleTableHandle.getTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        BlackHoleTableHandle oldTableHandle = Types.checkType(tableHandle, BlackHoleTableHandle.class, "tableHandle");
        BlackHoleTableHandle newTableHandle = new BlackHoleTableHandle(oldTableHandle.getSchemaName(), newTableName.getTableName(), oldTableHandle.getColumnHandles(), oldTableHandle.getSplitCount(), oldTableHandle.getPagesPerSplit(), oldTableHandle.getRowsPerPage(), oldTableHandle.getFieldsLength());
        this.tables.remove(oldTableHandle.getTableName());
        this.tables.put(newTableName.getTableName(), newTableHandle);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        ConnectorOutputTableHandle outputTableHandle = this.beginCreateTable(session, tableMetadata, Optional.empty());
        this.finishCreateTable(session, outputTableHandle, (Collection<Slice>)ImmutableList.of());
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession connectorSession, ConnectorTableMetadata tableMetadata) {
        List distributeColumns = (List)tableMetadata.getProperties().get("distributed_on");
        if (distributeColumns.isEmpty()) {
            return Optional.empty();
        }
        Sets.SetView undefinedColumns = Sets.difference((Set)ImmutableSet.copyOf((Collection)distributeColumns), tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toSet()));
        if (!undefinedColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Distribute columns not defined on table: " + undefinedColumns);
        }
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)BlackHolePartitioningHandle.INSTANCE, distributeColumns));
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        int splitCount = (Integer)tableMetadata.getProperties().get("split_count");
        int pagesPerSplit = (Integer)tableMetadata.getProperties().get("pages_per_split");
        int rowsPerPage = (Integer)tableMetadata.getProperties().get("rows_per_page");
        int fieldsLength = (Integer)tableMetadata.getProperties().get("field_length");
        if (splitCount < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "split_count property is negative");
        }
        if (pagesPerSplit < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "pages_per_split property is negative");
        }
        if (rowsPerPage < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "rows_per_page property is negative");
        }
        if (!(splitCount <= 0 && pagesPerSplit <= 0 && rowsPerPage <= 0 || splitCount != 0 && pagesPerSplit != 0 && rowsPerPage != 0)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, MessageFormat.format("All properties [%s, %s, %s] must be set if any are set", "split_count", "pages_per_split", "rows_per_page"));
        }
        return new BlackHoleOutputTableHandle(new BlackHoleTableHandle(tableMetadata, splitCount, pagesPerSplit, rowsPerPage, fieldsLength));
    }

    public void finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        BlackHoleOutputTableHandle blackHoleOutputTableHandle = Types.checkType(tableHandle, BlackHoleOutputTableHandle.class, "tableHandle");
        BlackHoleTableHandle table = blackHoleOutputTableHandle.getTable();
        this.tables.put(table.getTableName(), table);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return BlackHoleInsertTableHandle.BLACK_HOLE_INSERT_TABLE_HANDLE;
    }

    public void finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments) {
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle handle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        Objects.requireNonNull(handle, "handle is null");
        Preconditions.checkArgument((boolean)(handle instanceof BlackHoleTableHandle));
        BlackHoleTableHandle blackHoleHandle = (BlackHoleTableHandle)handle;
        BlackHoleTableLayoutHandle layoutHandle = new BlackHoleTableLayoutHandle(blackHoleHandle.getSplitCount(), blackHoleHandle.getPagesPerSplit(), blackHoleHandle.getRowsPerPage(), blackHoleHandle.getFieldsLength());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(this.getTableLayout(session, layoutHandle), TupleDomain.all()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle, Optional.empty(), TupleDomain.none(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }
}

