/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;

public class BlackHoleNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final String connectorId;
    private final NodeManager nodeManager;

    public BlackHoleNodePartitioningProvider(String connectorId, NodeManager nodeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public Map<Integer, Node> getBucketToNode(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        Set nodes = this.nodeManager.getActiveDatasourceNodes(this.connectorId);
        if (nodes.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No black hole nodes available");
        }
        ImmutableMap.Builder distribution = ImmutableMap.builder();
        int partNumber = 0;
        for (Node node : nodes) {
            distribution.put((Object)partNumber, (Object)node);
            ++partNumber;
        }
        return distribution.build();
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Black hole connector does not supported distributed reads");
        };
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        return (page, position) -> {
            int hash = 13;
            for (int i = 0; i < partitionChannelTypes.size(); ++i) {
                Type type = (Type)partitionChannelTypes.get(i);
                hash = 31 * hash + type.hash(page.getBlock(i), position);
            }
            return Math.abs(hash) % bucketCount;
        };
    }
}

