/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.plugin.blackhole.BlackHoleColumnHandle;
import com.facebook.presto.plugin.blackhole.BlackHoleSplit;
import com.facebook.presto.plugin.blackhole.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class BlackHolePageSourceProvider
implements ConnectorPageSourceProvider {
    private static final Set<Type> SUPPORTED_TYPES = ImmutableSet.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)DateType.DATE, (Object)TimestampType.TIMESTAMP, (Object)VarcharType.VARCHAR, (Object[])new Type[]{VarbinaryType.VARBINARY});

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        BlackHoleSplit blackHoleSplit = Types.checkType(split, BlackHoleSplit.class, "BlackHoleSplit");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            builder.add((Object)Types.checkType(column, BlackHoleColumnHandle.class, "BlackHoleColumnHandle").getColumnType());
        }
        ImmutableList types = builder.build();
        return new FixedPageSource(Iterables.limit((Iterable)Iterables.cycle((Object[])new Page[]{this.generateZeroPage((List<Type>)types, blackHoleSplit.getRowsPerPage(), blackHoleSplit.getFieldsLength())}), (int)blackHoleSplit.getPagesCount()));
    }

    private Page generateZeroPage(List<Type> types, int rowsCount, int fieldsLength) {
        byte[] constantBytes = new byte[fieldsLength];
        Arrays.fill(constantBytes, (byte)42);
        Slice constantSlice = Slices.wrappedBuffer((byte[])constantBytes);
        Block[] blocks = new Block[types.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.createZeroBlock(types.get(i), rowsCount, constantSlice);
        }
        return new Page(rowsCount, blocks);
    }

    private Block createZeroBlock(Type type, int rowsCount, Slice constantSlice) {
        Preconditions.checkArgument((boolean)SUPPORTED_TYPES.contains(type), (String)"Unsupported type [%s]", (Object[])new Object[]{type});
        BlockBuilder builder = type instanceof FixedWidthType ? type.createBlockBuilder(new BlockBuilderStatus(), rowsCount) : type.createBlockBuilder(new BlockBuilderStatus(), rowsCount, constantSlice.length());
        for (int i = 0; i < rowsCount; ++i) {
            Class javaType = type.getJavaType();
            if (javaType == Boolean.TYPE) {
                type.writeBoolean(builder, false);
                continue;
            }
            if (javaType == Long.TYPE) {
                type.writeLong(builder, 0L);
                continue;
            }
            if (javaType == Double.TYPE) {
                type.writeDouble(builder, 0.0);
                continue;
            }
            if (javaType == Slice.class) {
                type.writeSlice(builder, constantSlice, 0, constantSlice.length());
                continue;
            }
            throw new UnsupportedOperationException("Unknown javaType: " + javaType.getName());
        }
        return builder.build();
    }
}

