/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.plugin.blackhole.BlackHoleConnectorFactory;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public final class BlackHolePlugin
implements Plugin {
    private NodeManager nodeManager;
    private TypeManager typeManager;

    @Inject
    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    @Inject
    public void setTypeManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public <T> List<T> getServices(Class<T> type) {
        if (type == ConnectorFactory.class) {
            Preconditions.checkState((this.nodeManager != null ? 1 : 0) != 0, (Object)"NodeManager has not been set");
            Preconditions.checkState((this.typeManager != null ? 1 : 0) != 0, (Object)"TypeManager has not been set");
            return ImmutableList.of(type.cast(new BlackHoleConnectorFactory(this.nodeManager, this.typeManager)));
        }
        return ImmutableList.of();
    }
}

