/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.plugin.blackhole.BlackHoleColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class BlackHoleTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<BlackHoleColumnHandle> columnHandles;
    private final int splitCount;
    private final int pagesPerSplit;
    private final int rowsPerPage;
    private final int fieldsLength;

    public BlackHoleTableHandle(ConnectorTableMetadata tableMetadata, int splitCount, int pagesPerSplit, int rowsPerPage, int fieldsLength) {
        this(tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), tableMetadata.getColumns().stream().map(BlackHoleColumnHandle::new).collect(Collectors.toList()), splitCount, pagesPerSplit, rowsPerPage, fieldsLength);
    }

    @JsonCreator
    public BlackHoleTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnHandles") List<BlackHoleColumnHandle> columnHandles, @JsonProperty(value="splitCount") int splitCount, @JsonProperty(value="pagesPerSplit") int pagesPerSplit, @JsonProperty(value="rowsPerPage") int rowsPerPage, @JsonProperty(value="fieldsLength") int fieldsLength) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnHandles = columnHandles;
        this.splitCount = splitCount;
        this.pagesPerSplit = pagesPerSplit;
        this.rowsPerPage = rowsPerPage;
        this.fieldsLength = fieldsLength;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<BlackHoleColumnHandle> getColumnHandles() {
        return this.columnHandles;
    }

    @JsonProperty
    public int getSplitCount() {
        return this.splitCount;
    }

    @JsonProperty
    public int getPagesPerSplit() {
        return this.pagesPerSplit;
    }

    @JsonProperty
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @JsonProperty
    public int getFieldsLength() {
        return this.fieldsLength;
    }

    public ConnectorTableMetadata toTableMetadata() {
        return new ConnectorTableMetadata(this.toSchemaTableName(), this.columnHandles.stream().map(BlackHoleColumnHandle::toColumnMetadata).collect(Collectors.toList()));
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.getSchemaName(), this.getTableName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlackHoleTableHandle other = (BlackHoleTableHandle)obj;
        return Objects.equals(this.getSchemaName(), other.getSchemaName()) && Objects.equals(this.getTableName(), other.getTableName());
    }
}

