/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics.reporter.config;

import com.addthis.metrics.reporter.config.PredicateConfig;
import com.yammer.metrics.core.MetricPredicate;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public abstract class AbstractReporterConfig {
    @NotNull
    @Min(value=1L)
    private long period;
    @NotNull
    @Pattern(regexp="^(DAYS|HOURS|MICROSECONDS|MILLISECONDS|MINUTES|NANOSECONDS|SECONDS)$", message="must be a valid java.util.concurrent.TimeUnit")
    private String timeunit;
    @Valid
    private PredicateConfig predicate;

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public String getTimeunit() {
        return this.timeunit;
    }

    public void setTimeunit(String timeunit) {
        this.timeunit = timeunit;
    }

    public TimeUnit getRealTimeunit() {
        return TimeUnit.valueOf(this.timeunit);
    }

    public PredicateConfig getPredicate() {
        return this.predicate;
    }

    public void setPredicate(PredicateConfig predicate) {
        this.predicate = predicate;
    }

    protected boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public MetricPredicate getMetricPredicate() {
        if (this.predicate == null) {
            return MetricPredicate.ALL;
        }
        return this.predicate;
    }

    public abstract boolean enable();
}

