/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class ArrayLengthBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;

    public ArrayLengthBytecodeExpression(BytecodeExpression instance) {
        super(ParameterizedType.type(Integer.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(OpCode.ARRAYLENGTH);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + ".length";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

