/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import io.airlift.dbpool.H2EmbeddedDataSourceConfig;
import io.airlift.dbpool.ManagedDataSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import javax.sql.PooledConnection;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.util.ScriptReader;

public class H2EmbeddedDataSource
extends ManagedDataSource {
    private final JdbcDataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public H2EmbeddedDataSource(H2EmbeddedDataSourceConfig config) throws Exception {
        super(config.getMaxConnections(), config.getMaxConnectionWait());
        Preconditions.checkNotNull((Object)config.getFilename());
        if (config.getFilename().isEmpty()) {
            throw new IllegalArgumentException("filename is empty");
        }
        StringBuilder jdbcUrlBuilder = new StringBuilder().append("jdbc:h2:").append(config.getFilename()).append(";MVCC=").append(config.isMvccEnabled());
        if (config.getCipher() != H2EmbeddedDataSourceConfig.Cipher.NONE) {
            jdbcUrlBuilder.append(";CIPHER=").append((Object)config.getCipher());
        }
        String jdbcUrl = jdbcUrlBuilder.toString();
        this.dataSource = new JdbcDataSource();
        this.dataSource.setURL(jdbcUrl);
        this.dataSource.setUser("sa");
        if (config.getCipher() != H2EmbeddedDataSourceConfig.Cipher.NONE) {
            this.dataSource.setPassword(config.getFilePassword() + " ");
        } else {
            this.dataSource.setPassword("");
        }
        this.dataSource.setLoginTimeout(Ints.checkedCast((long)config.getMaxConnectionWait().roundTo(TimeUnit.SECONDS)));
        Connection connection = this.getConnection();
        try {
            H2EmbeddedDataSource.setConfig(connection, "CACHE_SIZE", config.getCacheSize());
            H2EmbeddedDataSource.setConfig(connection, "COMPRESS_LOB", (Object)config.getCompressLob());
            H2EmbeddedDataSource.setConfig(connection, "MAX_MEMORY_ROWS", config.getMaxMemoryRows());
            H2EmbeddedDataSource.setConfig(connection, "MAX_LENGTH_INPLACE_LOB", config.getMaxLengthInplaceLob());
            H2EmbeddedDataSource.setConfig(connection, "DB_CLOSE_DELAY ", "-1");
            String fileName = config.getInitScript();
            if (fileName != null) {
                File file = new File(fileName);
                URL url = file.exists() ? file.toURI().toURL() : this.getClass().getClassLoader().getResource(fileName);
                if (url == null) {
                    throw new FileNotFoundException(fileName);
                }
                try (Reader reader = Resources.asCharSource((URL)url, (Charset)StandardCharsets.UTF_8).openStream();){
                    ScriptReader scriptReader = new ScriptReader(reader);
                    String statement = scriptReader.readStatement();
                    while (statement != null) {
                        H2EmbeddedDataSource.executeCommand(connection, statement);
                        statement = scriptReader.readStatement();
                    }
                }
            }
            H2EmbeddedDataSource.setConfig(connection, "ALLOW_LITERALS", (Object)config.getAllowLiterals());
        }
        finally {
            H2EmbeddedDataSource.closeQuietly(connection);
        }
    }

    @Override
    protected PooledConnection createConnectionInternal() throws SQLException {
        return this.dataSource.getPooledConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setConfig(Connection connection, String name, Object value) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            String command = String.format("SET %s %s", name, value);
            int count = statement.executeUpdate(command);
            if (count != 0) {
                throw new SQLException("Failed to execute command: " + command);
            }
        }
        finally {
            H2EmbeddedDataSource.closeQuietly(statement);
        }
    }

    private static void executeCommand(Connection connection, String command) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate(command);
        }
        finally {
            H2EmbeddedDataSource.closeQuietly(statement);
        }
    }

    private static void closeQuietly(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeQuietly(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

