/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.ForwardWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class HiveOpConverterPostProc
implements Transform {
    private static final Log LOG = LogFactory.getLog(HiveOpConverterPostProc.class);
    private ParseContext pctx;
    private Map<String, Operator<? extends OperatorDesc>> aliasToOpInfo;
    private Map<String, String> opToAlias;
    private int uniqueCounter;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        boolean cboEnabled = HiveConf.getBoolVar(pctx.getConf(), HiveConf.ConfVars.HIVE_CBO_ENABLED);
        boolean returnPathEnabled = HiveConf.getBoolVar(pctx.getConf(), HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP);
        boolean cboSucceeded = pctx.getContext().isCboSucceeded();
        if (!(cboEnabled && returnPathEnabled && cboSucceeded)) {
            return pctx;
        }
        this.pctx = pctx;
        this.aliasToOpInfo = new HashMap<String, Operator<? extends OperatorDesc>>();
        this.opToAlias = new HashMap<String, String>();
        this.uniqueCounter = 0;
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", JoinOperator.getOperatorName() + "%"), new JoinAnnotate());
        opRules.put(new RuleRegExp("R2", TableScanOperator.getOperatorName() + "%"), new TableScanAnnotate());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new DefaultAnnotate(), opRules, null);
        ForwardWalker ogw = new ForwardWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private String genUniqueAlias() {
        return "op-" + ++this.uniqueCounter;
    }

    private class DefaultAnnotate
    implements NodeProcessor {
        private DefaultAnnotate() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            if (op.getParentOperators().size() == 1) {
                String opAlias = (String)HiveOpConverterPostProc.this.opToAlias.get(op.getParentOperators().get(0).toString());
                HiveOpConverterPostProc.this.opToAlias.put(op.toString(), opAlias);
            } else {
                String opAlias = HiveOpConverterPostProc.this.genUniqueAlias();
                HiveOpConverterPostProc.this.opToAlias.put(op.toString(), opAlias);
            }
            return null;
        }
    }

    private class TableScanAnnotate
    implements NodeProcessor {
        private TableScanAnnotate() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator tableScanOp = (TableScanOperator)nd;
            String opAlias = null;
            for (Map.Entry<String, Operator<? extends OperatorDesc>> topOpEntry : HiveOpConverterPostProc.this.pctx.getTopOps().entrySet()) {
                if (topOpEntry.getValue() != tableScanOp) continue;
                opAlias = topOpEntry.getKey();
            }
            assert (opAlias != null);
            HiveOpConverterPostProc.this.aliasToOpInfo.put(opAlias, tableScanOp);
            HiveOpConverterPostProc.this.opToAlias.put(tableScanOp.toString(), opAlias);
            return null;
        }
    }

    private class JoinAnnotate
    implements NodeProcessor {
        private JoinAnnotate() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator joinOp = (JoinOperator)nd;
            joinOp.getName();
            String[] baseSrc = new String[joinOp.getParentOperators().size()];
            String[] rightAliases = new String[joinOp.getParentOperators().size() - 1];
            for (int i = 0; i < joinOp.getParentOperators().size(); ++i) {
                ReduceSinkOperator rsOp = (ReduceSinkOperator)joinOp.getParentOperators().get(i);
                String opId = rsOp.getParentOperators().get(0).toString();
                baseSrc[i] = (String)HiveOpConverterPostProc.this.opToAlias.get(opId);
                if (i == 0) {
                    ((JoinDesc)joinOp.getConf()).setLeftAlias(baseSrc[i]);
                    continue;
                }
                rightAliases[i - 1] = baseSrc[i];
            }
            ((JoinDesc)joinOp.getConf()).setBaseSrc(baseSrc);
            ((JoinDesc)joinOp.getConf()).setRightAliases(rightAliases);
            ((JoinDesc)joinOp.getConf()).setAliasToOpInfo(HiveOpConverterPostProc.this.aliasToOpInfo);
            String joinOpAlias = HiveOpConverterPostProc.this.genUniqueAlias();
            HiveOpConverterPostProc.this.aliasToOpInfo.put(joinOpAlias, joinOp);
            HiveOpConverterPostProc.this.opToAlias.put(joinOp.toString(), joinOpAlias);
            HiveOpConverterPostProc.this.pctx.getJoinOps().add(joinOp);
            return null;
        }
    }
}

