/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.Table;

public class DynamicPartitionCtx
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> partSpec;
    private int numDPCols;
    private int numSPCols;
    private String spPath;
    private Path rootPath;
    private int numBuckets;
    private Map<String, String> inputToDPCols;
    private List<String> spNames;
    private List<String> dpNames;
    private String defaultPartName;
    private int maxPartsPerNode;

    public DynamicPartitionCtx() {
    }

    public DynamicPartitionCtx(Table tbl, Map<String, String> partSpec, String defaultPartName, int maxParts) {
        this.partSpec = partSpec;
        this.spNames = new ArrayList<String>();
        this.dpNames = new ArrayList<String>();
        this.numBuckets = 0;
        this.maxPartsPerNode = maxParts;
        this.defaultPartName = defaultPartName;
        for (Map.Entry<String, String> me : partSpec.entrySet()) {
            if (me.getValue() == null) {
                this.dpNames.add(me.getKey());
                continue;
            }
            this.spNames.add(me.getKey());
        }
        this.numDPCols = this.dpNames.size();
        this.numSPCols = this.spNames.size();
        this.inputToDPCols = new HashMap<String, String>();
        this.spPath = this.numSPCols > 0 ? Warehouse.makeDynamicPartName(partSpec) : null;
    }

    public DynamicPartitionCtx(DynamicPartitionCtx dp) {
        this.partSpec = dp.partSpec;
        this.numDPCols = dp.numDPCols;
        this.numSPCols = dp.numSPCols;
        this.spPath = dp.spPath;
        this.rootPath = dp.rootPath;
        this.numBuckets = dp.numBuckets;
        this.inputToDPCols = dp.inputToDPCols;
        this.spNames = dp.spNames;
        this.dpNames = dp.dpNames;
        this.defaultPartName = dp.defaultPartName;
        this.maxPartsPerNode = dp.maxPartsPerNode;
    }

    public void mapInputToDP(List<ColumnInfo> fs) {
        assert (fs.size() == this.numDPCols) : "input DP column size != numDPCols";
        Iterator<ColumnInfo> itr1 = fs.iterator();
        Iterator<String> itr2 = this.dpNames.iterator();
        while (itr1.hasNext() && itr2.hasNext()) {
            this.inputToDPCols.put(itr1.next().getInternalName(), itr2.next());
        }
    }

    public int getMaxPartitionsPerNode() {
        return this.maxPartsPerNode;
    }

    public void setMaxPartitionsPerNode(int maxParts) {
        this.maxPartsPerNode = maxParts;
    }

    public String getDefaultPartitionName() {
        return this.defaultPartName;
    }

    public void setDefaultPartitionName(String pname) {
        this.defaultPartName = pname;
    }

    public void setNumBuckets(int bk) {
        this.numBuckets = bk;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setRootPath(Path root) {
        this.rootPath = root;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public List<String> getDPColNames() {
        return this.dpNames;
    }

    public void setDPColNames(List<String> dp) {
        this.dpNames = dp;
    }

    public List<String> getSPColNames() {
        return this.spNames;
    }

    public void setPartSpec(Map<String, String> ps) {
        this.partSpec = ps;
    }

    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setSPColNames(List<String> sp) {
        this.spNames = sp;
    }

    public Map<String, String> getInputToDPCols() {
        return this.inputToDPCols;
    }

    public void setInputToDPCols(Map<String, String> map) {
        this.inputToDPCols = map;
    }

    public void setNumDPCols(int dp) {
        this.numDPCols = dp;
    }

    public int getNumDPCols() {
        return this.numDPCols;
    }

    public void setNumSPCols(int sp) {
        this.numSPCols = sp;
    }

    public int getNumSPCols() {
        return this.numSPCols;
    }

    public void setSPPath(String sp) {
        this.spPath = sp;
    }

    public String getSPPath() {
        return this.spPath;
    }
}

