/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.ColumnStatistics;
import com.facebook.hive.orc.CompressionKind;
import com.facebook.hive.orc.MemoryManager;
import com.facebook.hive.orc.Reader;
import com.facebook.hive.orc.ReaderImpl;
import com.facebook.hive.orc.StripeInformation;
import com.facebook.hive.orc.Writer;
import com.facebook.hive.orc.WriterImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.WritableComparable;

public final class OrcFile {
    public static final String MAGIC = "ORC";
    public static final String COMPRESSION = "orc.compress";
    public static final String COMPRESSION_BLOCK_SIZE = "orc.compress.size";
    public static final String STRIPE_SIZE = "orc.stripe.size";
    public static final String ROW_INDEX_STRIDE = "orc.row.index.stride";
    public static final String ENABLE_INDEXES = "orc.create.index";
    private static MemoryManager memoryManager = null;

    private OrcFile() {
    }

    public static Reader createReader(FileSystem fs, Path path, Configuration conf) throws IOException {
        return new ReaderImpl(fs, path, conf);
    }

    public static Writer createWriter(FileSystem fs, Path path, Configuration conf, ObjectInspector inspector, long stripeSize, CompressionKind compress, int bufferSize, int rowIndexStride) throws IOException {
        return new WriterImpl(fs, path, conf, inspector, stripeSize, compress, bufferSize, rowIndexStride, OrcFile.getMemoryManager(conf));
    }

    private static synchronized MemoryManager getMemoryManager(Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new MemoryManager(conf);
        }
        return memoryManager;
    }

    public static class ValueWrapper
    implements WritableComparable<ValueWrapper> {
        public byte[] value;

        public void readFields(DataInput in) throws IOException {
            throw new RuntimeException("Not supported.");
        }

        public void write(DataOutput out) throws IOException {
            throw new RuntimeException("Not supported.");
        }

        public int compareTo(ValueWrapper o) {
            throw new RuntimeException("Not supported.");
        }
    }

    public static class KeyWrapper
    implements WritableComparable<KeyWrapper> {
        public StripeInformation key;
        public Path inputPath;
        public ObjectInspector objectInspector;
        public CompressionKind compression;
        public int compressionSize;
        public int rowIndexStride;
        public ColumnStatistics[] columnStats;
        public Map<String, ByteBuffer> userMetadata;

        public void readFields(DataInput in) throws IOException {
            throw new RuntimeException("Not supported.");
        }

        public void write(DataOutput out) throws IOException {
            throw new RuntimeException("Not supported.");
        }

        public int compareTo(KeyWrapper o) {
            throw new RuntimeException("Not supported.");
        }
    }
}

