/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.BitFieldWriter;
import com.facebook.hive.orc.ColumnStatisticsImpl;
import com.facebook.hive.orc.CompressionCodec;
import com.facebook.hive.orc.CompressionKind;
import com.facebook.hive.orc.DictionaryEncoder;
import com.facebook.hive.orc.DynamicIntArray;
import com.facebook.hive.orc.IntDictionaryEncoder;
import com.facebook.hive.orc.MemoryManager;
import com.facebook.hive.orc.OrcConf;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OutStream;
import com.facebook.hive.orc.PositionRecorder;
import com.facebook.hive.orc.PositionedOutputStream;
import com.facebook.hive.orc.RunLengthByteWriter;
import com.facebook.hive.orc.RunLengthIntegerWriter;
import com.facebook.hive.orc.SerializationUtils;
import com.facebook.hive.orc.SnappyCodec;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.StringDictionaryEncoder;
import com.facebook.hive.orc.StripeInformation;
import com.facebook.hive.orc.Writer;
import com.facebook.hive.orc.ZlibCodec;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.ReaderWriterProfiler;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

public class WriterImpl
implements Writer,
MemoryManager.Callback {
    private static final Log LOG = LogFactory.getLog(WriterImpl.class);
    private static final int HDFS_BUFFER_SIZE = 262144;
    private static final int MIN_ROW_INDEX_STRIDE = 1000;
    public static final int SHORT_BYTE_SIZE = 2;
    public static final int INT_BYTE_SIZE = 4;
    public static final int LONG_BYTE_SIZE = 8;
    public static final int UNCOMPRESSED_PRESENT_STREAM_INDEX_ENTRIES = 3;
    public static final int COMPRESSED_PRESENT_STREAM_INDEX_ENTRIES = 4;
    private final FileSystem fs;
    private final Path path;
    private final long stripeSize;
    private final int rowIndexStride;
    private final CompressionKind compress;
    private final CompressionCodec codec;
    private final int bufferSize;
    private final Map<StreamName, BufferedStream> streams = new TreeMap<StreamName, BufferedStream>();
    private FSDataOutputStream rawWriter = null;
    private OutStream writer = null;
    private CodedOutputStream protobufWriter = null;
    private long headerLength;
    private int columnCount;
    private long rowCount = 0L;
    private long rowsInStripe = 0L;
    private int rowsInIndex = 0;
    private long rawDataSize = 0L;
    private final List<OrcProto.StripeInformation> stripes = new ArrayList<OrcProto.StripeInformation>();
    private final Map<String, ByteString> userMetadata = new TreeMap<String, ByteString>();
    private final StreamFactory streamFactory = new StreamFactory();
    private final TreeWriter treeWriter;
    private final OrcProto.RowIndex.Builder rowIndex = OrcProto.RowIndex.newBuilder();
    private final boolean buildIndex;
    private final MemoryManager memoryManager;
    private final boolean useVInts;
    private final int dfsBytesPerChecksum;
    private final long initialSize;
    private final long maxDictSize;
    private final Configuration conf;
    public static final int MILLIS_PER_SECOND = 1000;
    public static final long BASE_TIMESTAMP = Timestamp.valueOf("2015-01-01 00:00:00").getTime() / 1000L;

    WriterImpl(FileSystem fs, Path path, Configuration conf, ObjectInspector inspector, long stripeSize, CompressionKind compress, int bufferSize, int rowIndexStride, MemoryManager memoryManager) throws IOException {
        this.fs = fs;
        this.path = path;
        this.conf = conf;
        this.stripeSize = stripeSize;
        this.compress = compress;
        this.bufferSize = bufferSize;
        this.rowIndexStride = rowIndexStride;
        this.memoryManager = memoryManager;
        this.buildIndex = rowIndexStride > 0;
        this.codec = WriterImpl.createCodec(compress, conf);
        this.useVInts = OrcConf.getBoolVar(conf, OrcConf.ConfVars.HIVE_ORC_USE_VINTS);
        this.treeWriter = WriterImpl.createTreeWriter(inspector, this.streamFactory, false, conf, this.useVInts, memoryManager.isLowMemoryMode());
        this.dfsBytesPerChecksum = conf.getInt("io.bytes.per.checksum", 512);
        if (this.buildIndex && rowIndexStride < 1000) {
            throw new IllegalArgumentException("Row stride must be at least 1000");
        }
        this.maxDictSize = OrcConf.getLongVar(conf, OrcConf.ConfVars.HIVE_ORC_MAX_DICTIONARY_SIZE);
        this.initialSize = this.estimateStripeSize().getTotalMemory();
        memoryManager.addWriter(path, stripeSize, this, this.initialSize);
    }

    static CompressionCodec createCodec(CompressionKind kind) {
        return WriterImpl.createCodec(kind, null);
    }

    static CompressionCodec createCodec(CompressionKind kind, Configuration conf) {
        switch (kind) {
            case NONE: {
                return null;
            }
            case ZLIB: {
                return new ZlibCodec(conf);
            }
            case SNAPPY: {
                return new SnappyCodec();
            }
            case LZO: {
                try {
                    Class<?> lzo = Class.forName("com.facebook.hive.orc.LzoCodec");
                    return (CompressionCodec)lzo.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("LZO is not available.", e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Problem initializing LZO", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Insufficient access to LZO", e);
                }
            }
        }
        throw new IllegalArgumentException("Unknown compression codec: " + (Object)((Object)kind));
    }

    @Override
    public synchronized void enterLowMemoryMode() throws IOException {
        this.treeWriter.abandonDictionaries();
        if (this.codec != null && OrcConf.getIntVar(this.conf, OrcConf.ConfVars.HIVE_ORC_ZLIB_COMPRESSION_LEVEL) < 6) {
            OrcConf.setIntVar(this.conf, OrcConf.ConfVars.HIVE_ORC_ZLIB_COMPRESSION_LEVEL, 6);
            this.codec.reloadConfigurations(this.conf);
        }
    }

    @Override
    public synchronized boolean checkMemory(double newScale) throws IOException {
        long limit = Math.round((double)this.stripeSize * newScale);
        MemoryEstimate size = this.estimateStripeSize();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ORC writer " + this.path + " size = " + size.getTotalMemory() + " limit = " + limit));
        }
        if (size.getTotalMemory() > limit || this.maxDictSize > 0L && size.getDictionaryMemory() > this.maxDictSize) {
            this.flushStripe();
            return true;
        }
        return false;
    }

    private static TreeWriter createTreeWriter(ObjectInspector inspector, StreamFactory streamFactory, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)inspector).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return new BooleanTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
                    }
                    case BYTE: {
                        return new ByteTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
                    }
                    case SHORT: {
                        return new IntegerTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, 2, lowMemoryMode);
                    }
                    case INT: {
                        return new IntegerTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, 4, lowMemoryMode);
                    }
                    case LONG: {
                        return new IntegerTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, 8, lowMemoryMode);
                    }
                    case FLOAT: {
                        return new FloatTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
                    }
                    case DOUBLE: {
                        return new DoubleTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
                    }
                    case STRING: {
                        return new StringTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
                    }
                    case BINARY: {
                        return new BinaryTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
                    }
                    case TIMESTAMP: {
                        return new TimestampTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
                    }
                }
                throw new IllegalArgumentException("Bad primitive category " + ((PrimitiveObjectInspector)inspector).getPrimitiveCategory());
            }
            case STRUCT: {
                return new StructTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
            }
            case MAP: {
                return new MapTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
            }
            case LIST: {
                return new ListTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
            }
            case UNION: {
                return new UnionTreeWriter(streamFactory.getNextColumnId(), inspector, streamFactory, nullable, conf, useVInts, lowMemoryMode);
            }
        }
        throw new IllegalArgumentException("Bad category: " + inspector.getCategory());
    }

    private static void writeTypes(OrcProto.Footer.Builder builder, TreeWriter treeWriter) {
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        block0 : switch (treeWriter.inspector.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)treeWriter.inspector).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        type.setKind(OrcProto.Type.Kind.BOOLEAN);
                        break block0;
                    }
                    case BYTE: {
                        type.setKind(OrcProto.Type.Kind.BYTE);
                        break block0;
                    }
                    case SHORT: {
                        type.setKind(OrcProto.Type.Kind.SHORT);
                        break block0;
                    }
                    case INT: {
                        type.setKind(OrcProto.Type.Kind.INT);
                        break block0;
                    }
                    case LONG: {
                        type.setKind(OrcProto.Type.Kind.LONG);
                        break block0;
                    }
                    case FLOAT: {
                        type.setKind(OrcProto.Type.Kind.FLOAT);
                        break block0;
                    }
                    case DOUBLE: {
                        type.setKind(OrcProto.Type.Kind.DOUBLE);
                        break block0;
                    }
                    case STRING: {
                        type.setKind(OrcProto.Type.Kind.STRING);
                        break block0;
                    }
                    case BINARY: {
                        type.setKind(OrcProto.Type.Kind.BINARY);
                        break block0;
                    }
                    case TIMESTAMP: {
                        type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive category: " + ((PrimitiveObjectInspector)treeWriter.inspector).getPrimitiveCategory());
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(treeWriter.childrenWriters[0].id);
                break;
            }
            case MAP: {
                type.setKind(OrcProto.Type.Kind.MAP);
                type.addSubtypes(treeWriter.childrenWriters[0].id);
                type.addSubtypes(treeWriter.childrenWriters[1].id);
                break;
            }
            case STRUCT: {
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (TreeWriter child : treeWriter.childrenWriters) {
                    type.addSubtypes(child.id);
                }
                for (StructField field : ((StructTreeWriter)treeWriter).fields) {
                    type.addFieldNames(field.getFieldName());
                }
                break;
            }
            case UNION: {
                type.setKind(OrcProto.Type.Kind.UNION);
                for (TreeWriter child : treeWriter.childrenWriters) {
                    type.addSubtypes(child.id);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + treeWriter.inspector.getCategory());
            }
        }
        builder.addTypes(type);
        for (TreeWriter child : treeWriter.childrenWriters) {
            WriterImpl.writeTypes(builder, child);
        }
    }

    private void ensureWriter() throws IOException {
        if (this.rawWriter == null) {
            this.rawWriter = this.fs.create(this.path, false, 262144, this.fs.getDefaultReplication(), Math.min(this.stripeSize * 2L, (long)(Integer.MAX_VALUE / this.dfsBytesPerChecksum * this.dfsBytesPerChecksum)));
            this.rawWriter.writeBytes("ORC");
            this.headerLength = this.rawWriter.getPos();
            this.writer = new OutStream("metadata", this.bufferSize, this.codec, new DirectStream(this.rawWriter));
            this.protobufWriter = CodedOutputStream.newInstance((OutputStream)this.writer);
        }
    }

    private void createRowIndexEntry() throws IOException {
        this.treeWriter.flush();
        this.treeWriter.createRowIndexEntry();
        this.rowsInIndex = 0;
    }

    public void addStripe(StripeInformation si, byte[] data) throws IOException {
        this.ensureWriter();
        OrcProto.StripeInformation dirEntry = OrcProto.StripeInformation.newBuilder().setOffset(this.rawWriter.getPos()).setIndexLength(si.getIndexLength()).setDataLength(si.getDataLength()).setNumberOfRows(si.getNumberOfRows()).setFooterLength(si.getFooterLength()).build();
        this.stripes.add(dirEntry);
        this.rowCount += si.getNumberOfRows();
        this.rawWriter.write(data);
    }

    private List<Map.Entry<StreamName, BufferedStream>> cleanUpStreams() throws IOException {
        ArrayList<Map.Entry<StreamName, BufferedStream>> streamList = new ArrayList<Map.Entry<StreamName, BufferedStream>>(this.streams.size());
        HashMap<StreamName, Integer> indexMap = new HashMap<StreamName, Integer>(this.streams.size());
        int increment = 0;
        for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
            if (!pair.getValue().isSuppressed()) {
                Integer index;
                StreamName name = pair.getKey();
                if (name.getKind() == OrcProto.Stream.Kind.LENGTH && (index = (Integer)indexMap.get(new StreamName(name.getColumn(), OrcProto.Stream.Kind.DICTIONARY_DATA))) != null) {
                    streamList.add(index + increment, pair);
                    ++increment;
                    continue;
                }
                indexMap.put(name, new Integer(streamList.size()));
                streamList.add(pair);
                continue;
            }
            pair.getValue().clear();
        }
        return streamList;
    }

    private void flushStripe() throws IOException {
        this.ensureWriter();
        ReaderWriterProfiler.start((ReaderWriterProfiler.Counter)ReaderWriterProfiler.Counter.ENCODING_TIME);
        this.treeWriter.flush();
        if (this.buildIndex && this.rowsInIndex != 0) {
            this.createRowIndexEntry();
        }
        ReaderWriterProfiler.end((ReaderWriterProfiler.Counter)ReaderWriterProfiler.Counter.ENCODING_TIME);
        if (this.rowsInStripe != 0L) {
            long start;
            int requiredIndexEntries = this.rowIndexStride == 0 ? 0 : (int)((this.rowsInStripe + (long)this.rowIndexStride - 1L) / (long)this.rowIndexStride);
            OrcProto.StripeFooter.Builder builder = OrcProto.StripeFooter.newBuilder();
            long stripeRawDataSize = this.treeWriter.getStripeRawDataSize();
            ReaderWriterProfiler.start((ReaderWriterProfiler.Counter)ReaderWriterProfiler.Counter.SERIALIZATION_TIME);
            this.treeWriter.writeStripe(builder, requiredIndexEntries);
            ReaderWriterProfiler.end((ReaderWriterProfiler.Counter)ReaderWriterProfiler.Counter.SERIALIZATION_TIME);
            long section = start = this.rawWriter.getPos();
            long indexEnd = start;
            List<Map.Entry<StreamName, BufferedStream>> streamList = this.cleanUpStreams();
            for (Map.Entry<StreamName, BufferedStream> pair : streamList) {
                BufferedStream stream = pair.getValue();
                stream.flush(true);
                stream.spillTo((OutputStream)this.rawWriter);
                long end = this.rawWriter.getPos();
                StreamName name = pair.getKey();
                builder.addStreams(OrcProto.Stream.newBuilder().setColumn(name.getColumn()).setKind(name.getKind()).setLength(end - section).setUseVInts(this.useVInts));
                section = end;
                if (StreamName.Area.INDEX == name.getArea()) {
                    indexEnd = end;
                }
                stream.clear();
            }
            builder.build().writeTo(this.protobufWriter);
            this.protobufWriter.flush();
            this.writer.flush();
            long end = this.rawWriter.getPos();
            OrcProto.StripeInformation dirEntry = OrcProto.StripeInformation.newBuilder().setOffset(start).setIndexLength(indexEnd - start).setDataLength(section - indexEnd).setNumberOfRows(this.rowsInStripe).setFooterLength(end - section).setRawDataSize(stripeRawDataSize).build();
            this.stripes.add(dirEntry);
            this.rowCount += this.rowsInStripe;
            this.rawDataSize += stripeRawDataSize;
            this.rowsInStripe = 0L;
        }
    }

    private OrcProto.CompressionKind writeCompressionKind(CompressionKind kind) {
        switch (kind) {
            case NONE: {
                return OrcProto.CompressionKind.NONE;
            }
            case ZLIB: {
                return OrcProto.CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return OrcProto.CompressionKind.SNAPPY;
            }
            case LZO: {
                return OrcProto.CompressionKind.LZO;
            }
        }
        throw new IllegalArgumentException("Unknown compression " + (Object)((Object)kind));
    }

    private int writeFileStatistics(OrcProto.Footer.Builder builder, TreeWriter writer, ColumnStatisticsImpl[] columnStats, int column) {
        if (columnStats != null) {
            writer.fileStatistics.merge(columnStats[column++]);
        }
        builder.addStatistics(writer.fileStatistics.serialize());
        for (TreeWriter child : writer.getChildrenWriters()) {
            column = this.writeFileStatistics(builder, child, columnStats, column);
        }
        return column;
    }

    private int writeFooter(long bodyLength, ColumnStatisticsImpl[] columnStats) throws IOException {
        this.ensureWriter();
        OrcProto.Footer.Builder builder = OrcProto.Footer.newBuilder();
        builder.setContentLength(bodyLength);
        builder.setHeaderLength(this.headerLength);
        builder.setNumberOfRows(this.rowCount);
        builder.setRawDataSize(this.rawDataSize);
        builder.setRowIndexStride(this.rowIndexStride);
        WriterImpl.writeTypes(builder, this.treeWriter);
        for (OrcProto.StripeInformation stripeInformation : this.stripes) {
            builder.addStripes(stripeInformation);
        }
        this.writeFileStatistics(builder, this.treeWriter, columnStats, 0);
        for (Map.Entry entry : this.userMetadata.entrySet()) {
            builder.addMetadata(OrcProto.UserMetadataItem.newBuilder().setName((String)entry.getKey()).setValue((ByteString)entry.getValue()));
        }
        long startPosn = this.rawWriter.getPos();
        builder.build().writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
        return (int)(this.rawWriter.getPos() - startPosn);
    }

    private int writePostScript(int footerLength) throws IOException {
        OrcProto.PostScript.Builder builder = OrcProto.PostScript.newBuilder().setCompression(this.writeCompressionKind(this.compress)).setFooterLength(footerLength);
        if (this.compress != CompressionKind.NONE) {
            builder.setCompressionBlockSize(this.bufferSize);
        }
        OrcProto.PostScript ps = builder.build();
        long startPosn = this.rawWriter.getPos();
        ps.writeTo((OutputStream)this.rawWriter);
        long length = this.rawWriter.getPos() - startPosn;
        if (length > 255L) {
            throw new IllegalArgumentException("PostScript too large at " + length);
        }
        return (int)length;
    }

    private MemoryEstimate estimateStripeSize() {
        long result = 0L;
        for (BufferedStream stream : this.streams.values()) {
            result += stream.getBufferSize();
        }
        MemoryEstimate memoryEstimate = new MemoryEstimate();
        this.treeWriter.estimateMemory(memoryEstimate);
        memoryEstimate.incrementTotalMemory(result);
        return memoryEstimate;
    }

    @Override
    public synchronized void addUserMetadata(String name, ByteBuffer value) {
        this.userMetadata.put(name, ByteString.copyFrom((ByteBuffer)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRow(Object row) throws IOException {
        ReaderWriterProfiler.start((ReaderWriterProfiler.Counter)ReaderWriterProfiler.Counter.ENCODING_TIME);
        WriterImpl writerImpl = this;
        synchronized (writerImpl) {
            this.treeWriter.write(row);
            ++this.rowsInStripe;
            if (this.buildIndex) {
                ++this.rowsInIndex;
                if (this.rowsInIndex >= this.rowIndexStride) {
                    this.createRowIndexEntry();
                }
            }
        }
        this.memoryManager.addedRow();
        ReaderWriterProfiler.end((ReaderWriterProfiler.Counter)ReaderWriterProfiler.Counter.ENCODING_TIME);
    }

    @Override
    public long getRowRawDataSize() {
        return this.treeWriter.getRowRawDataSize();
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ColumnStatisticsImpl[] columnStats) throws IOException {
        this.memoryManager.removeWriter(this.path);
        WriterImpl writerImpl = this;
        synchronized (writerImpl) {
            this.flushStripe();
            int footerLength = this.writeFooter(this.rawWriter.getPos(), columnStats);
            this.rawWriter.writeByte(this.writePostScript(footerLength));
            this.rawWriter.close();
        }
    }

    private class MemoryEstimate {
        private long totalMemory;
        private long dictionaryMemory;

        private MemoryEstimate() {
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public void setTotalMemory(long totalMemory) {
            this.totalMemory = totalMemory;
        }

        public long getDictionaryMemory() {
            return this.dictionaryMemory;
        }

        public void setDictionaryMemory(long dictionaryMemory) {
            this.dictionaryMemory = dictionaryMemory;
        }

        public void incrementTotalMemory(long increment) {
            this.totalMemory += increment;
        }

        public void incrementDictionaryMemory(long increment) {
            this.dictionaryMemory += increment;
        }
    }

    private static class UnionTreeWriter
    extends TreeWriter {
        private final RunLengthByteWriter tags;

        UnionTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            UnionObjectInspector insp = (UnionObjectInspector)inspector;
            List choices = insp.getObjectInspectors();
            this.childrenWriters = new TreeWriter[choices.size()];
            for (int i = 0; i < this.childrenWriters.length; ++i) {
                this.childrenWriters[i] = WriterImpl.createTreeWriter((ObjectInspector)choices.get(i), writer, true, conf, useVInts, lowMemoryMode);
            }
            this.tags = new RunLengthByteWriter(writer.createStream(columnId, OrcProto.Stream.Kind.DATA));
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            long rawDataSize = 0L;
            if (obj != null) {
                UnionObjectInspector insp = (UnionObjectInspector)this.inspector;
                byte tag = insp.getTag(obj);
                this.tags.write(tag);
                this.childrenWriters[tag].write(insp.getField(obj));
                rawDataSize = this.childrenWriters[tag].getRowRawDataSize() + 1L;
            }
            super.write(obj, rawDataSize);
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.tags.flush();
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.tags.getPosition(recorder);
        }
    }

    private static class MapTreeWriter
    extends TreeWriter {
        private final RunLengthIntegerWriter lengths;

        MapTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            MapObjectInspector insp = (MapObjectInspector)inspector;
            this.childrenWriters = new TreeWriter[2];
            this.childrenWriters[0] = WriterImpl.createTreeWriter(insp.getMapKeyObjectInspector(), writer, true, conf, useVInts, lowMemoryMode);
            this.childrenWriters[1] = WriterImpl.createTreeWriter(insp.getMapValueObjectInspector(), writer, true, conf, useVInts, lowMemoryMode);
            this.lengths = new RunLengthIntegerWriter(writer.createStream(columnId, OrcProto.Stream.Kind.LENGTH), false, 4, useVInts);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            long rawDataSize = 0L;
            if (obj != null) {
                MapObjectInspector insp = (MapObjectInspector)this.inspector;
                int len = insp.getMapSize(obj);
                this.lengths.write(len);
                Map valueMap = insp.getMap(obj);
                for (Map.Entry entry : valueMap.entrySet()) {
                    this.childrenWriters[0].write(entry.getKey());
                    this.childrenWriters[1].write(entry.getValue());
                    rawDataSize += this.childrenWriters[0].getRowRawDataSize();
                    rawDataSize += this.childrenWriters[1].getRowRawDataSize();
                }
            }
            super.write(obj, rawDataSize);
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.lengths.flush();
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.lengths.getPosition(recorder);
        }
    }

    private static class ListTreeWriter
    extends TreeWriter {
        private final RunLengthIntegerWriter lengths;

        ListTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            ListObjectInspector listObjectInspector = (ListObjectInspector)inspector;
            this.childrenWriters = new TreeWriter[1];
            this.childrenWriters[0] = WriterImpl.createTreeWriter(listObjectInspector.getListElementObjectInspector(), writer, true, conf, useVInts, lowMemoryMode);
            this.lengths = new RunLengthIntegerWriter(writer.createStream(columnId, OrcProto.Stream.Kind.LENGTH), false, 4, useVInts);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            long rawDataSize = 0L;
            if (obj != null) {
                ListObjectInspector insp = (ListObjectInspector)this.inspector;
                int len = insp.getListLength(obj);
                this.lengths.write(len);
                for (int i = 0; i < len; ++i) {
                    this.childrenWriters[0].write(insp.getListElement(obj, i));
                    rawDataSize += this.childrenWriters[0].getRowRawDataSize();
                }
            }
            super.write(obj, rawDataSize);
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.lengths.flush();
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.lengths.getPosition(recorder);
        }
    }

    private static class StructTreeWriter
    extends TreeWriter {
        private final List<? extends StructField> fields;

        StructTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            StructObjectInspector structObjectInspector = (StructObjectInspector)inspector;
            this.fields = structObjectInspector.getAllStructFieldRefs();
            this.childrenWriters = new TreeWriter[this.fields.size()];
            for (int i = 0; i < this.childrenWriters.length; ++i) {
                this.childrenWriters[i] = WriterImpl.createTreeWriter(this.fields.get(i).getFieldObjectInspector(), writer, true, conf, useVInts, lowMemoryMode);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            long rawDataSize = 0L;
            if (obj != null) {
                StructObjectInspector insp = (StructObjectInspector)this.inspector;
                List fieldDataList = insp.getStructFieldsDataAsList(obj);
                for (int i = 0; i < this.fields.size(); ++i) {
                    TreeWriter writer = this.childrenWriters[i];
                    writer.write(fieldDataList.get(i));
                    rawDataSize += writer.getRowRawDataSize();
                }
            }
            super.write(obj, rawDataSize);
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }
    }

    private static class TimestampTreeWriter
    extends TreeWriter {
        private final RunLengthIntegerWriter seconds;
        private final RunLengthIntegerWriter nanos;

        TimestampTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            this.seconds = new RunLengthIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.DATA), true, 8, useVInts);
            this.nanos = new RunLengthIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.NANO_DATA), false, 8, useVInts);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj, 12L);
            if (obj != null) {
                Timestamp val = ((TimestampObjectInspector)this.inspector).getPrimitiveJavaObject(obj);
                this.seconds.write(val.getTime() / 1000L - BASE_TIMESTAMP);
                this.nanos.write(TimestampTreeWriter.formatNanos(val.getNanos()));
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.seconds.flush();
            this.nanos.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        private static long formatNanos(int nanos) {
            int trailingZeros;
            if (nanos == 0) {
                return 0L;
            }
            if (nanos % 100 != 0) {
                return (long)nanos << 3;
            }
            nanos /= 100;
            for (trailingZeros = 1; nanos % 10 == 0 && trailingZeros < 7; ++trailingZeros) {
                nanos /= 10;
            }
            return (long)nanos << 3 | (long)trailingZeros;
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.seconds.getPosition(recorder);
            this.nanos.getPosition(recorder);
        }
    }

    private static class BinaryTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stream;
        private final RunLengthIntegerWriter length;

        BinaryTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.length = new RunLengthIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, 4, useVInts);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            long rawDataSize = 0L;
            if (obj != null) {
                BytesWritable val = ((BinaryObjectInspector)this.inspector).getPrimitiveWritableObject(obj);
                this.stream.write(val.getBytes(), 0, val.getLength());
                this.length.write(val.getLength());
                rawDataSize = val.getLength();
            }
            super.write(obj, rawDataSize);
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.stream.flush();
            this.length.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.stream.getPosition(recorder);
            this.length.getPosition(recorder);
        }
    }

    private static class StringTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stringOutput;
        private final RunLengthIntegerWriter lengthOutput;
        private final PositionedOutputStream inDictionaryStream;
        private final BitFieldWriter inDictionary;
        private StringDictionaryEncoder dictionary;
        private DynamicIntArray rows;
        private final RunLengthIntegerWriter directLengthOutput;
        private final RunLengthIntegerWriter strideDictionaryLengthOutput;
        private final List<OrcProto.RowIndexEntry> savedRowIndex = new ArrayList<OrcProto.RowIndexEntry>();
        private final boolean buildIndex;
        private final List<Long> rowIndexValueCount = new ArrayList<Long>();
        private final StreamFactory writer;
        private final float dictionaryKeySizeThreshold;
        private final float entropyKeySizeThreshold;
        private final int entropyMinSamples;
        private final float entropyDictSampleFraction;
        private final int entropyThreshold;
        private boolean useDictionaryEncoding = true;
        private final boolean useStrideDictionaries;
        private final boolean sortKeys;
        private final Text[] buffer;
        private int bufferIndex = 0;
        private long bufferedBytes = 0L;
        private final int recomputeStripeEncodingInterval;
        private PositionedOutputStream rowOutput;
        private final PositionedOutputStream strideDictionaryOutput;
        private boolean abandonDictionaries = false;
        private int dictionarySize;

        StringTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writerFactory, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writerFactory, nullable, conf, useVInts);
            this.writer = writerFactory;
            this.sortKeys = OrcConf.getBoolVar(conf, OrcConf.ConfVars.HIVE_ORC_DICTIONARY_SORT_KEYS);
            this.useStrideDictionaries = OrcConf.getBoolVar(conf, OrcConf.ConfVars.HIVE_ORC_BUILD_STRIDE_DICTIONARY);
            this.recomputeStripeEncodingInterval = OrcConf.getIntVar(conf, OrcConf.ConfVars.HIVE_ORC_DICTIONARY_ENCODING_INTERVAL);
            if (!lowMemoryMode) {
                this.dictionary = new StringDictionaryEncoder(this.sortKeys, this.useStrideDictionaries);
                this.rows = new DynamicIntArray();
            } else {
                this.abandonDictionaries = true;
                this.rowOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
                this.useDictionaryEncoding = false;
            }
            this.stringOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.DICTIONARY_DATA);
            this.lengthOutput = new RunLengthIntegerWriter(this.writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, 4, useVInts);
            this.inDictionaryStream = this.writer.createStream(this.id, OrcProto.Stream.Kind.IN_DICTIONARY);
            this.inDictionary = new BitFieldWriter(this.inDictionaryStream, 1);
            this.strideDictionaryLengthOutput = new RunLengthIntegerWriter(this.writer.createStream(this.id, OrcProto.Stream.Kind.STRIDE_DICTIONARY_LENGTH), false, 4, useVInts);
            this.strideDictionaryOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.STRIDE_DICTIONARY);
            this.directLengthOutput = new RunLengthIntegerWriter(this.writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, 4, useVInts);
            this.dictionaryKeySizeThreshold = OrcConf.getFloatVar(conf, OrcConf.ConfVars.HIVE_ORC_DICTIONARY_STRING_KEY_SIZE_THRESHOLD);
            this.entropyKeySizeThreshold = OrcConf.getFloatVar(conf, OrcConf.ConfVars.HIVE_ORC_ENTROPY_KEY_STRING_SIZE_THRESHOLD);
            this.entropyMinSamples = OrcConf.getIntVar(conf, OrcConf.ConfVars.HIVE_ORC_ENTROPY_STRING_MIN_SAMPLES);
            this.entropyDictSampleFraction = OrcConf.getFloatVar(conf, OrcConf.ConfVars.HIVE_ORC_ENTROPY_STRING_DICT_SAMPLE_FRACTION);
            this.entropyThreshold = OrcConf.getIntVar(conf, OrcConf.ConfVars.HIVE_ORC_ENTROPY_STRING_THRESHOLD);
            int bufferLength = OrcConf.getIntVar(conf, OrcConf.ConfVars.HIVE_ORC_ROW_BUFFER_SIZE);
            this.buffer = new Text[bufferLength];
            this.recordPosition(this.rowIndexPosition);
            this.rowIndexValueCount.add(0L);
            this.buildIndex = this.writer.buildIndex();
            if (this.buildIndex && lowMemoryMode) {
                this.rowOutput.getPosition(this.rowIndexPosition);
                this.directLengthOutput.getPosition(this.rowIndexPosition);
            }
        }

        boolean determineEncodingStripe() {
            return this.getNumStripes() % this.recomputeStripeEncodingInterval == 0 && !this.abandonDictionaries;
        }

        @Override
        void write(Object obj) throws IOException {
            if (obj != null) {
                Text val = ((StringObjectInspector)this.inspector).getPrimitiveWritableObject(obj);
                this.buffer[this.bufferIndex++] = new Text(val);
                this.setRawDataSize(val.getLength());
                this.bufferedBytes += (long)val.getLength();
            } else {
                this.buffer[this.bufferIndex++] = null;
                this.setRawDataSize(1L);
            }
            if (this.bufferIndex == this.buffer.length) {
                this.flush();
            }
        }

        @Override
        void flush() throws IOException {
            for (int i = 0; i < this.bufferIndex; ++i) {
                Text val = this.buffer[i];
                this.buffer[i] = null;
                if (val != null) {
                    this.indexStatistics.updateString(val.toString());
                    if (this.useCarriedOverDirectEncoding()) {
                        this.rowOutput.write(val.getBytes());
                        this.directLengthOutput.write(val.getLength());
                    } else {
                        this.rows.add(this.dictionary.add(val, this.savedRowIndex.size()));
                    }
                }
                super.flushRow(val);
            }
            this.bufferIndex = 0;
            this.bufferedBytes = 0L;
        }

        private boolean isEntropyThresholdExceeded(Set<Character> chars, Text text, int index) {
            this.dictionary.getText(text, index);
            for (char character : text.toString().toCharArray()) {
                chars.add(Character.valueOf(character));
            }
            return chars.size() > this.entropyThreshold;
        }

        private int[] getSampleIndecesForEntropy() {
            int numSamples = Math.max(this.entropyMinSamples, (int)(this.entropyDictSampleFraction * (float)this.dictionary.size()));
            int[] indeces = new int[this.dictionary.size()];
            int[] samples = new int[numSamples];
            Random rand = new Random();
            for (int i = 0; i < numSamples; ++i) {
                int index = rand.nextInt(this.dictionary.size() - i);
                samples[i] = indeces[index] == 0 ? index : indeces[index];
                indeces[index] = indeces[this.dictionary.size() - i - 1] == 0 ? this.dictionary.size() - i - 1 : indeces[this.dictionary.size() - i - 1];
            }
            return samples;
        }

        private boolean useDictionaryEncodingEntropyHeuristic() {
            HashSet<Character> chars = new HashSet<Character>();
            Text text = new Text();
            if (this.dictionary.size() > this.entropyMinSamples) {
                int[] samples;
                for (int sampleIndex : samples = this.getSampleIndecesForEntropy()) {
                    if (!this.isEntropyThresholdExceeded(chars, text, sampleIndex)) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < this.dictionary.size(); ++i) {
                    if (!this.isEntropyThresholdExceeded(chars, text, i)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean useCarriedOverDirectEncoding() {
            return !this.determineEncodingStripe() && !this.useDictionaryEncoding;
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            boolean[] strideDictionaryIndexPopulated;
            int[] strideDictionarySizes;
            int[] counts;
            int[] dumpOrder;
            if (this.determineEncodingStripe() && this.rows.size() > 0) {
                this.useDictionaryEncoding = true;
                float repeatedValuesFraction = (float)(this.rows.size() - this.dictionary.size()) / (float)this.rows.size();
                if (repeatedValuesFraction <= this.entropyKeySizeThreshold) {
                    this.useDictionaryEncoding = this.useDictionaryEncodingEntropyHeuristic();
                }
                boolean bl = this.useDictionaryEncoding = this.useDictionaryEncoding && (double)repeatedValuesFraction > 1.0 - (double)this.dictionaryKeySizeThreshold;
            }
            if (this.useDictionaryEncoding) {
                this.rowOutput = new RunLengthIntegerWriter(this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA), false, 4, this.useVInts);
            } else if (this.determineEncodingStripe()) {
                this.rowOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            }
            if (this.useDictionaryEncoding) {
                dumpOrder = new int[this.dictionary.size()];
                counts = new int[this.dictionary.size()];
                strideDictionarySizes = new int[this.savedRowIndex.size()];
                strideDictionaryIndexPopulated = new boolean[this.savedRowIndex.size()];
                OrcProto.RowIndexEntry.Builder base = this.savedRowIndex.get(0).toBuilder();
                RowIndexPositionRecorder recorder = new RowIndexPositionRecorder(base);
                this.strideDictionaryOutput.getPosition(recorder);
                this.strideDictionaryLengthOutput.getPosition(recorder);
                this.savedRowIndex.set(0, base.build());
                strideDictionaryIndexPopulated[0] = true;
                this.dictionary.visit(new DictionaryEncoder.Visitor<Text>(){
                    private int currentId = 0;
                    private int directId = 0;
                    private int previousIndex = 0;

                    @Override
                    public void visit(DictionaryEncoder.VisitorContext<Text> context) throws IOException {
                        counts[context.getOriginalPosition()] = context.getCount();
                        if (!StringTreeWriter.this.useStrideDictionaries || context.getCount() > 1) {
                            StringTreeWriter.this.dictionarySize++;
                            context.writeBytes(StringTreeWriter.this.stringOutput);
                            StringTreeWriter.this.lengthOutput.write(context.getLength());
                            dumpOrder[context.getOriginalPosition()] = this.currentId++;
                        } else {
                            int nextIndex = context.getIndexStride();
                            if (nextIndex != this.previousIndex) {
                                for (int i = this.previousIndex; i < nextIndex; ++i) {
                                    OrcProto.RowIndexEntry.Builder base = ((OrcProto.RowIndexEntry)StringTreeWriter.this.savedRowIndex.get(i + 1)).toBuilder();
                                    RowIndexPositionRecorder recorder = new RowIndexPositionRecorder(base);
                                    StringTreeWriter.this.strideDictionaryOutput.getPosition(recorder);
                                    StringTreeWriter.this.strideDictionaryLengthOutput.getPosition(recorder);
                                    StringTreeWriter.this.savedRowIndex.set(i + 1, base.build());
                                    strideDictionaryIndexPopulated[i + 1] = true;
                                }
                                this.previousIndex = context.getIndexStride();
                                this.directId = 0;
                            }
                            context.writeBytes(StringTreeWriter.this.strideDictionaryOutput);
                            int n = this.previousIndex;
                            strideDictionarySizes[n] = strideDictionarySizes[n] + 1;
                            StringTreeWriter.this.strideDictionaryLengthOutput.write(context.getLength());
                            dumpOrder[context.getOriginalPosition()] = this.directId++;
                        }
                    }
                });
            } else {
                dumpOrder = null;
                counts = null;
                strideDictionarySizes = null;
                strideDictionaryIndexPopulated = null;
            }
            if (!this.useCarriedOverDirectEncoding()) {
                this.writeData(this.useDictionaryEncoding, dumpOrder, counts, strideDictionarySizes, strideDictionaryIndexPopulated);
            }
            super.writeStripe(builder, requiredIndexEntries);
            this.rowOutput.flush();
            if (this.useDictionaryEncoding) {
                this.stringOutput.unsuppress();
                this.lengthOutput.unsuppress();
                this.inDictionary.flush();
                this.strideDictionaryOutput.flush();
                this.strideDictionaryLengthOutput.flush();
                if (this.dictionarySize == this.dictionary.size()) {
                    this.inDictionaryStream.suppress();
                    this.strideDictionaryOutput.suppress();
                    this.strideDictionaryLengthOutput.suppress();
                } else {
                    this.inDictionaryStream.unsuppress();
                    this.strideDictionaryOutput.unsuppress();
                    this.strideDictionaryLengthOutput.unsuppress();
                }
                this.directLengthOutput.suppress();
                this.stringOutput.flush();
                this.lengthOutput.flush();
            } else {
                this.directLengthOutput.unsuppress();
                this.stringOutput.suppress();
                this.lengthOutput.suppress();
                this.inDictionaryStream.suppress();
                this.strideDictionaryOutput.suppress();
                this.strideDictionaryLengthOutput.suppress();
                this.directLengthOutput.flush();
            }
            this.savedRowIndex.clear();
            this.rowIndexValueCount.clear();
            this.recordPosition(this.rowIndexPosition);
            this.dictionarySize = 0;
            if (this.useCarriedOverDirectEncoding()) {
                this.rowOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
                this.rowOutput.getPosition(this.rowIndexPosition);
                this.directLengthOutput.getPosition(this.rowIndexPosition);
                this.dictionary = null;
                this.rows = null;
            } else {
                if (this.dictionary == null) {
                    this.dictionary = new StringDictionaryEncoder(this.sortKeys, this.useStrideDictionaries);
                } else {
                    this.dictionary.clear();
                }
                if (this.rows == null) {
                    this.rows = new DynamicIntArray();
                } else {
                    this.rows.clear();
                }
            }
            this.rowIndexValueCount.add(0L);
        }

        private void convertDictionaryToDirect() throws IOException {
            this.writeData(false, null, null, null, null);
        }

        private void writeData(boolean useDictionaryEncoding, int[] dumpOrder, int[] counts, int[] strideDictionarySizes, boolean[] strideDictionaryIndexPopulated) throws IOException {
            int rowIndexEntry = 0;
            OrcProto.RowIndex.Builder rowIndex = this.getRowIndex();
            int length = this.rows.size();
            Text text = new Text();
            for (int i = 0; i <= length; ++i) {
                if (this.buildIndex) {
                    while ((long)i == this.rowIndexValueCount.get(rowIndexEntry) && rowIndexEntry < this.savedRowIndex.size()) {
                        OrcProto.RowIndexEntry.Builder base = this.savedRowIndex.get(rowIndexEntry++).toBuilder();
                        if (this.useStrideDictionaries && useDictionaryEncoding && !strideDictionaryIndexPopulated[rowIndexEntry - 1] && this.dictionary.size() != this.dictionarySize) {
                            RowIndexPositionRecorder recorder = new RowIndexPositionRecorder(base);
                            this.strideDictionaryOutput.getPosition(recorder);
                            this.strideDictionaryLengthOutput.getPosition(recorder);
                        }
                        if (this.useStrideDictionaries && strideDictionarySizes != null && this.dictionary.size() != this.dictionarySize) {
                            base.addPositions(strideDictionarySizes[rowIndexEntry - 1]);
                        }
                        this.recordOutputPosition(this.rowOutput, base);
                        rowIndex.addEntry(base.build());
                    }
                }
                if (i == length) continue;
                if (useDictionaryEncoding) {
                    this.rowOutput.write(dumpOrder[this.rows.get(i)]);
                    if (!this.useStrideDictionaries || counts[this.rows.get(i)] > 1) {
                        this.inDictionary.write(1);
                        continue;
                    }
                    this.inDictionary.write(0);
                    continue;
                }
                this.dictionary.getText(text, this.rows.get(i));
                this.rowOutput.write(text.getBytes(), 0, text.getLength());
                this.directLengthOutput.write(text.getLength());
            }
        }

        private void recordOutputPosition(PositionedOutputStream rowOutput, OrcProto.RowIndexEntry.Builder base) throws IOException {
            RowIndexPositionRecorder recorder = new RowIndexPositionRecorder(base);
            rowOutput.getPosition(recorder);
            if (!this.useDictionaryEncoding) {
                this.directLengthOutput.getPosition(recorder);
            } else if (this.dictionary.size() != this.dictionarySize) {
                this.inDictionary.getPosition(recorder);
            }
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.useDictionaryEncoding) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY).setDictionarySize(this.dictionarySize).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void createRowIndexEntry() throws IOException {
            this.getFileStatistics().merge(this.indexStatistics);
            OrcProto.RowIndexEntry.Builder rowIndexEntry = this.getRowIndexEntry();
            rowIndexEntry.setStatistics(this.indexStatistics.serialize());
            this.indexStatistics.reset();
            if (this.useCarriedOverDirectEncoding()) {
                this.getRowIndex().addEntry(rowIndexEntry);
            } else {
                this.savedRowIndex.add(rowIndexEntry.build());
            }
            rowIndexEntry.clear();
            this.recordPosition(this.rowIndexPosition);
            if (this.useCarriedOverDirectEncoding()) {
                this.rowOutput.getPosition(this.rowIndexPosition);
                this.directLengthOutput.getPosition(this.rowIndexPosition);
            } else {
                this.rowIndexValueCount.add(Long.valueOf(this.rows.size()));
            }
        }

        @Override
        void estimateMemory(MemoryEstimate memoryEstimate) {
            memoryEstimate.incrementTotalMemory((long)(this.rows == null ? 0 : this.rows.getSizeInBytes()) + (this.dictionary == null ? 0L : this.dictionary.getSizeInBytes()) + this.bufferedBytes + (this.rowOutput == null ? 0L : this.rowOutput.getBufferSize()) + (this.directLengthOutput == null ? 0L : this.directLengthOutput.getBufferSize()) + (this.strideDictionaryOutput == null ? 0L : this.strideDictionaryOutput.getBufferSize()) + (this.strideDictionaryLengthOutput == null ? 0L : this.strideDictionaryLengthOutput.getBufferSize()));
            memoryEstimate.incrementDictionaryMemory(this.dictionary == null ? 0L : (long)this.dictionary.getUncompressedLength());
        }

        @Override
        public void abandonDictionaries() throws IOException {
            this.abandonDictionaries = true;
            if (this.useDictionaryEncoding) {
                this.rowOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
                this.useDictionaryEncoding = false;
                this.convertDictionaryToDirect();
                if (this.rows.size() == 0) {
                    this.rowOutput.getPosition(this.rowIndexPosition);
                    this.directLengthOutput.getPosition(this.rowIndexPosition);
                }
            }
            this.dictionary = null;
            this.rows = null;
            this.savedRowIndex.clear();
        }
    }

    private static class DoubleTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stream;

        DoubleTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj, 8L);
            if (obj != null) {
                double val = ((DoubleObjectInspector)this.inspector).get(obj);
                this.indexStatistics.updateDouble(val);
                SerializationUtils.writeDouble(this.stream, val);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.stream.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.stream.getPosition(recorder);
        }
    }

    private static class FloatTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stream;

        FloatTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj, 4L);
            if (obj != null) {
                float val = ((FloatObjectInspector)this.inspector).get(obj);
                this.indexStatistics.updateDouble(val);
                SerializationUtils.writeFloat(this.stream, val);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.stream.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.stream.getPosition(recorder);
        }
    }

    private static class IntegerTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream output;
        private DynamicIntArray rows;
        private final PositionedOutputStream inDictionaryStream;
        private final BitFieldWriter inDictionary;
        private final List<OrcProto.RowIndexEntry> savedRowIndex = new ArrayList<OrcProto.RowIndexEntry>();
        private final boolean buildIndex;
        private final List<Long> rowIndexValueCount = new ArrayList<Long>();
        private final float dictionaryKeySizeThreshold;
        private IntDictionaryEncoder dictionary;
        private boolean useDictionaryEncoding = true;
        private final StreamFactory writer;
        private final int numBytes;
        private final Long[] buffer;
        private int bufferIndex = 0;
        private long bufferedBytes = 0L;
        private final int recomputeStripeEncodingInterval;
        PositionedOutputStream rowOutput;
        private boolean abandonDictionaries = false;
        private final boolean sortKeys;
        private int dictionarySize;
        private final boolean useStrideDictionaries;

        IntegerTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writerFactory, boolean nullable, Configuration conf, boolean useVInts, int numBytes, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writerFactory, nullable, conf, useVInts);
            this.writer = writerFactory;
            this.sortKeys = OrcConf.getBoolVar(conf, OrcConf.ConfVars.HIVE_ORC_DICTIONARY_SORT_KEYS);
            this.useStrideDictionaries = OrcConf.getBoolVar(conf, OrcConf.ConfVars.HIVE_ORC_BUILD_STRIDE_DICTIONARY);
            this.numBytes = numBytes;
            this.recomputeStripeEncodingInterval = OrcConf.getIntVar(conf, OrcConf.ConfVars.HIVE_ORC_DICTIONARY_ENCODING_INTERVAL);
            if (!lowMemoryMode) {
                this.dictionary = new IntDictionaryEncoder(this.sortKeys, numBytes, useVInts);
                this.rows = new DynamicIntArray();
            } else {
                this.abandonDictionaries = true;
                this.rowOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
                this.useDictionaryEncoding = false;
            }
            this.output = this.writer.createStream(this.id, OrcProto.Stream.Kind.DICTIONARY_DATA);
            this.inDictionaryStream = this.writer.createStream(this.id, OrcProto.Stream.Kind.IN_DICTIONARY);
            this.inDictionary = new BitFieldWriter(this.inDictionaryStream, 1);
            this.dictionaryKeySizeThreshold = OrcConf.getFloatVar(conf, OrcConf.ConfVars.HIVE_ORC_DICTIONARY_NUMERIC_KEY_SIZE_THRESHOLD);
            int bufferLength = OrcConf.getIntVar(conf, OrcConf.ConfVars.HIVE_ORC_ROW_BUFFER_SIZE);
            this.buffer = new Long[bufferLength];
            this.recordPosition(this.rowIndexPosition);
            this.rowIndexValueCount.add(0L);
            this.buildIndex = this.writer.buildIndex();
            if (this.buildIndex && lowMemoryMode) {
                this.rowOutput.getPosition(this.rowIndexPosition);
            }
        }

        boolean determineEncodingStripe() {
            return this.getNumStripes() % this.recomputeStripeEncodingInterval == 0 && !this.abandonDictionaries;
        }

        @Override
        void write(Object obj) throws IOException {
            if (obj != null) {
                block0 : switch (this.inspector.getCategory()) {
                    case PRIMITIVE: {
                        switch (((PrimitiveObjectInspector)this.inspector).getPrimitiveCategory()) {
                            case SHORT: {
                                this.buffer[this.bufferIndex++] = new Long(((ShortObjectInspector)this.inspector).get(obj));
                                this.setRawDataSize(2L);
                                break block0;
                            }
                            case INT: {
                                this.buffer[this.bufferIndex++] = new Long(((IntObjectInspector)this.inspector).get(obj));
                                this.setRawDataSize(4L);
                                break block0;
                            }
                            case LONG: {
                                this.buffer[this.bufferIndex++] = new Long(((LongObjectInspector)this.inspector).get(obj));
                                this.setRawDataSize(8L);
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Bad Category: Dictionary Encoding not available for " + ((PrimitiveObjectInspector)this.inspector).getPrimitiveCategory());
                    }
                    default: {
                        throw new IllegalArgumentException("Bad Category: DictionaryEncoding not available for " + this.inspector.getCategory());
                    }
                }
                this.bufferedBytes += 8L;
            } else {
                this.buffer[this.bufferIndex++] = null;
                this.setRawDataSize(1L);
            }
            if (this.bufferIndex == this.buffer.length) {
                this.flush();
            }
        }

        @Override
        void flush() throws IOException {
            for (int i = 0; i < this.bufferIndex; ++i) {
                Long val = this.buffer[i];
                this.buffer[i] = null;
                if (val != null) {
                    if (this.useCarriedOverDirectEncoding()) {
                        SerializationUtils.writeIntegerType(this.rowOutput, val, this.numBytes, true, this.useVInts);
                    } else {
                        this.rows.add(this.dictionary.add(val));
                    }
                    this.indexStatistics.updateInteger(val);
                }
                super.flushRow(val);
            }
            this.bufferIndex = 0;
            this.bufferedBytes = 0L;
        }

        boolean getUseDictionaryEncoding() {
            return this.rows.size() > 0 && (float)this.dictionary.size() / (float)this.rows.size() <= this.dictionaryKeySizeThreshold;
        }

        private boolean useCarriedOverDirectEncoding() {
            return !this.determineEncodingStripe() && !this.useDictionaryEncoding;
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            int[] counts;
            long[] dumpOrder;
            if (this.determineEncodingStripe()) {
                this.useDictionaryEncoding = this.getUseDictionaryEncoding();
            }
            if (this.useDictionaryEncoding) {
                this.rowOutput = new RunLengthIntegerWriter(this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA), false, 4, this.useVInts);
            } else if (this.determineEncodingStripe()) {
                this.rowOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            }
            if (this.useDictionaryEncoding) {
                dumpOrder = new long[this.dictionary.size()];
                counts = new int[this.dictionary.size()];
                this.dictionary.visit(new DictionaryEncoder.Visitor<Long>(){
                    int currentId = 0;

                    @Override
                    public void visit(DictionaryEncoder.VisitorContext<Long> context) throws IOException {
                        int count;
                        counts[context.getOriginalPosition()] = count = context.getCount();
                        if (!IntegerTreeWriter.this.useStrideDictionaries || count > 1) {
                            IntegerTreeWriter.this.dictionarySize++;
                            context.writeBytes(IntegerTreeWriter.this.output);
                            dumpOrder[context.getOriginalPosition()] = this.currentId++;
                        } else {
                            dumpOrder[context.getOriginalPosition()] = IntegerTreeWriter.this.dictionary.getValue(context.getOriginalPosition());
                        }
                    }
                });
            } else {
                dumpOrder = null;
                counts = null;
            }
            if (!this.useCarriedOverDirectEncoding()) {
                this.writeData(this.useDictionaryEncoding, dumpOrder, counts);
            }
            super.writeStripe(builder, requiredIndexEntries);
            if (this.useDictionaryEncoding) {
                this.output.unsuppress();
                this.inDictionary.flush();
                if (this.dictionarySize == this.dictionary.size()) {
                    this.inDictionaryStream.suppress();
                } else {
                    this.inDictionaryStream.unsuppress();
                }
                this.output.flush();
            } else {
                this.output.suppress();
                this.inDictionaryStream.suppress();
            }
            this.rowOutput.flush();
            this.savedRowIndex.clear();
            this.rowIndexValueCount.clear();
            this.recordPosition(this.rowIndexPosition);
            this.dictionarySize = 0;
            if (this.useCarriedOverDirectEncoding()) {
                this.rowOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
                this.rowOutput.getPosition(this.rowIndexPosition);
                this.dictionary = null;
                this.rows = null;
            } else {
                if (this.dictionary == null) {
                    this.dictionary = new IntDictionaryEncoder(this.sortKeys, this.numBytes, this.useVInts);
                } else {
                    this.dictionary.clear();
                }
                if (this.rows == null) {
                    this.rows = new DynamicIntArray();
                } else {
                    this.rows.clear();
                }
            }
            this.rowIndexValueCount.add(0L);
        }

        private void convertDictionaryToDirect() throws IOException {
            this.writeData(false, null, null);
        }

        private void writeData(boolean useDictionaryEncoding, long[] dumpOrder, int[] counts) throws IOException {
            int length = this.rows.size();
            int rowIndexEntry = 0;
            OrcProto.RowIndex.Builder rowIndex = this.getRowIndex();
            for (int i = 0; i <= length; ++i) {
                if (this.buildIndex) {
                    while ((long)i == this.rowIndexValueCount.get(rowIndexEntry) && rowIndexEntry < this.savedRowIndex.size()) {
                        OrcProto.RowIndexEntry.Builder base = this.savedRowIndex.get(rowIndexEntry++).toBuilder();
                        RowIndexPositionRecorder recorder = new RowIndexPositionRecorder(base);
                        if (useDictionaryEncoding && dumpOrder != null && this.dictionarySize != this.dictionary.size()) {
                            this.inDictionary.getPosition(recorder);
                        }
                        this.rowOutput.getPosition(recorder);
                        rowIndex.addEntry(base.build());
                    }
                }
                if (i >= length) continue;
                if (useDictionaryEncoding && dumpOrder != null) {
                    ((RunLengthIntegerWriter)this.rowOutput).write(dumpOrder[this.rows.get(i)]);
                    if (!this.useStrideDictionaries || counts[this.rows.get(i)] > 1) {
                        this.inDictionary.write(1);
                        continue;
                    }
                    this.inDictionary.write(0);
                    continue;
                }
                SerializationUtils.writeIntegerType(this.rowOutput, this.dictionary.getValue(this.rows.get(i)), this.numBytes, true, this.useVInts);
            }
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.useDictionaryEncoding) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY).setDictionarySize(this.dictionarySize).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void createRowIndexEntry() throws IOException {
            this.getFileStatistics().merge(this.indexStatistics);
            OrcProto.RowIndexEntry.Builder rowIndexEntry = this.getRowIndexEntry();
            rowIndexEntry.setStatistics(this.indexStatistics.serialize());
            this.indexStatistics.reset();
            if (this.useCarriedOverDirectEncoding()) {
                this.getRowIndex().addEntry(rowIndexEntry);
            } else {
                this.savedRowIndex.add(rowIndexEntry.build());
            }
            rowIndexEntry.clear();
            this.recordPosition(this.rowIndexPosition);
            if (this.useCarriedOverDirectEncoding()) {
                this.rowOutput.getPosition(this.rowIndexPosition);
            } else {
                this.rowIndexValueCount.add(Long.valueOf(this.rows.size()));
            }
        }

        @Override
        void estimateMemory(MemoryEstimate memoryEstimate) {
            memoryEstimate.incrementTotalMemory((long)(this.rows == null ? 0 : this.rows.size() * 4) + (this.dictionary == null ? 0L : this.dictionary.getByteSize()) + this.bufferedBytes + (this.rowOutput == null ? 0L : this.rowOutput.getBufferSize()));
            memoryEstimate.incrementDictionaryMemory(this.dictionary == null ? 0L : (long)this.dictionary.getUncompressedLength());
        }

        @Override
        public void abandonDictionaries() throws IOException {
            this.abandonDictionaries = true;
            if (this.useDictionaryEncoding) {
                this.rowOutput = this.writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
                this.useDictionaryEncoding = false;
                this.convertDictionaryToDirect();
                if (this.rows.size() == 0) {
                    this.rowOutput.getPosition(this.rowIndexPosition);
                }
            }
            this.dictionary = null;
            this.rows = null;
            this.savedRowIndex.clear();
        }
    }

    private static class ByteTreeWriter
    extends TreeWriter {
        private final RunLengthByteWriter writer;

        ByteTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            this.writer = new RunLengthByteWriter(writer.createStream(this.id, OrcProto.Stream.Kind.DATA));
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj, 1L);
            if (obj != null) {
                byte val = ((ByteObjectInspector)this.inspector).get(obj);
                this.indexStatistics.updateInteger(val);
                this.writer.write(val);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }
    }

    private static class BooleanTreeWriter
    extends TreeWriter {
        private final BitFieldWriter writer;

        BooleanTreeWriter(int columnId, ObjectInspector inspector, StreamFactory writer, boolean nullable, Configuration conf, boolean useVInts, boolean lowMemoryMode) throws IOException {
            super(columnId, inspector, writer, nullable, conf, useVInts);
            OutStream out = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.writer = new BitFieldWriter(out, 1);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void write(Object obj) throws IOException {
            super.write(obj, 1L);
            if (obj != null) {
                boolean val = ((BooleanObjectInspector)this.inspector).get(obj);
                this.indexStatistics.updateBoolean(val);
                this.writer.write(val ? 1 : 0);
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }
    }

    private static abstract class TreeWriter {
        protected final int id;
        protected final ObjectInspector inspector;
        private final BitFieldWriter isPresent;
        private final boolean isCompressed;
        protected final ColumnStatisticsImpl indexStatistics;
        private final ColumnStatisticsImpl fileStatistics;
        protected TreeWriter[] childrenWriters;
        protected final RowIndexPositionRecorder rowIndexPosition;
        private final OrcProto.RowIndex.Builder rowIndex;
        private final OrcProto.RowIndexEntry.Builder rowIndexEntry;
        private final PositionedOutputStream rowIndexStream;
        private final Configuration conf;
        protected long stripeRawDataSize = 0L;
        protected long rowRawDataSize = 0L;
        protected final boolean useVInts;
        private int numStripes = 0;
        private boolean foundNulls;
        private OutStream isPresentOutStream;

        TreeWriter(int columnId, ObjectInspector inspector, StreamFactory streamFactory, boolean nullable, Configuration conf, boolean useVInts) throws IOException {
            this.id = columnId;
            this.inspector = inspector;
            this.conf = conf;
            this.useVInts = useVInts;
            this.isCompressed = streamFactory.isCompressed();
            if (nullable) {
                this.isPresentOutStream = streamFactory.createStream(this.id, OrcProto.Stream.Kind.PRESENT);
                this.isPresent = new BitFieldWriter(this.isPresentOutStream, 1);
            } else {
                this.isPresent = null;
            }
            this.foundNulls = false;
            this.indexStatistics = ColumnStatisticsImpl.create(inspector);
            this.fileStatistics = ColumnStatisticsImpl.create(inspector);
            this.childrenWriters = new TreeWriter[0];
            this.rowIndex = OrcProto.RowIndex.newBuilder();
            this.rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
            this.rowIndexPosition = new RowIndexPositionRecorder(this.rowIndexEntry);
            this.rowIndexStream = streamFactory.buildIndex() ? streamFactory.createStream(this.id, OrcProto.Stream.Kind.ROW_INDEX) : null;
        }

        protected int getNumStripes() {
            return this.numStripes;
        }

        protected OrcProto.RowIndex.Builder getRowIndex() {
            return this.rowIndex;
        }

        protected ColumnStatisticsImpl getFileStatistics() {
            return this.fileStatistics;
        }

        protected OrcProto.RowIndexEntry.Builder getRowIndexEntry() {
            return this.rowIndexEntry;
        }

        abstract void write(Object var1) throws IOException;

        void write(Object obj, long rawDataSize) throws IOException {
            if (obj != null) {
                this.setRawDataSize(rawDataSize);
            } else {
                this.setRawDataSize(1L);
            }
            this.flushRow(obj);
        }

        void flushRow(Object obj) throws IOException {
            if (obj != null) {
                this.indexStatistics.increment();
            }
            if (this.isPresent != null) {
                this.isPresent.write(obj == null ? 0 : 1);
                if (obj == null) {
                    this.foundNulls = true;
                }
            }
        }

        private void removeIsPresentPositions() {
            for (int i = 0; i < this.rowIndex.getEntryCount(); ++i) {
                OrcProto.RowIndexEntry.Builder entry = this.rowIndex.getEntryBuilder(i);
                List<Long> positions = entry.getPositionsList();
                positions = positions.subList(this.isCompressed ? 4 : 3, positions.size());
                entry.clearPositions();
                entry.addAllPositions(positions);
            }
        }

        protected void setRawDataSize(long rawDataSize) {
            this.rowRawDataSize = rawDataSize;
            this.stripeRawDataSize += rawDataSize;
        }

        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            ++this.numStripes;
            if (this.isPresent != null) {
                this.isPresent.flush();
                if (!this.foundNulls) {
                    this.isPresentOutStream.suppress();
                    if (this.rowIndexStream != null) {
                        this.removeIsPresentPositions();
                    }
                }
            }
            this.foundNulls = false;
            builder.addColumns(this.getEncoding());
            if (this.rowIndexStream != null) {
                if (this.rowIndex.getEntryCount() != requiredIndexEntries) {
                    throw new IllegalArgumentException("Column has wrong number of index entries found: " + this.rowIndex.getEntryCount() + " expected: " + requiredIndexEntries);
                }
                this.rowIndex.build().writeTo(this.rowIndexStream);
                this.rowIndexStream.flush();
            }
            this.rowIndex.clear();
            this.rowIndexEntry.clear();
            this.stripeRawDataSize = 0L;
        }

        TreeWriter[] getChildrenWriters() {
            return this.childrenWriters;
        }

        void flush() throws IOException {
            for (TreeWriter writer : this.childrenWriters) {
                writer.flush();
            }
        }

        OrcProto.ColumnEncoding getEncoding() {
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        void createRowIndexEntry() throws IOException {
            this.fileStatistics.merge(this.indexStatistics);
            this.rowIndexEntry.setStatistics(this.indexStatistics.serialize());
            this.indexStatistics.reset();
            this.rowIndex.addEntry(this.rowIndexEntry);
            this.rowIndexEntry.clear();
            this.recordPosition(this.rowIndexPosition);
            for (TreeWriter child : this.childrenWriters) {
                child.createRowIndexEntry();
            }
        }

        void recordPosition(PositionRecorder recorder) throws IOException {
            if (this.isPresent != null) {
                this.isPresent.getPosition(recorder);
            }
        }

        void estimateMemory(MemoryEstimate memoryEstimate) {
            for (TreeWriter child : this.childrenWriters) {
                child.estimateMemory(memoryEstimate);
            }
        }

        public void abandonDictionaries() throws IOException {
            for (TreeWriter child : this.childrenWriters) {
                child.abandonDictionaries();
            }
        }

        long getStripeRawDataSize() {
            return this.stripeRawDataSize;
        }

        long getRowRawDataSize() {
            return this.rowRawDataSize;
        }
    }

    private class StreamFactory {
        private StreamFactory() {
        }

        public OutStream createStream(int column, OrcProto.Stream.Kind kind) throws IOException {
            StreamName name = new StreamName(column, kind);
            BufferedStream result = (BufferedStream)WriterImpl.this.streams.get(name);
            if (result == null) {
                result = new BufferedStream(name.toString(), WriterImpl.this.bufferSize, WriterImpl.this.codec);
                WriterImpl.this.streams.put(name, result);
            }
            return result.outStream;
        }

        public int getNextColumnId() {
            return WriterImpl.this.columnCount++;
        }

        public int getRowIndexStride() {
            return WriterImpl.this.rowIndexStride;
        }

        public boolean buildIndex() {
            return WriterImpl.this.buildIndex;
        }

        public boolean isCompressed() {
            return WriterImpl.this.codec != null;
        }
    }

    static class RowIndexPositionRecorder
    implements PositionRecorder {
        private final OrcProto.RowIndexEntry.Builder builder;

        RowIndexPositionRecorder(OrcProto.RowIndexEntry.Builder builder) {
            this.builder = builder;
        }

        @Override
        public void addPosition(long position) {
            this.builder.addPositions(position);
        }
    }

    private class DirectStream
    implements OutStream.OutputReceiver {
        private final FSDataOutputStream output;

        DirectStream(FSDataOutputStream output) {
            this.output = output;
        }

        @Override
        public void output(ByteBuffer buffer) throws IOException {
            this.output.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
    }

    private class BufferedStream
    implements OutStream.OutputReceiver {
        private final OutStream outStream;
        private final List<ByteBuffer> output = new ArrayList<ByteBuffer>();

        BufferedStream(String name, int bufferSize, CompressionCodec codec) throws IOException {
            this.outStream = new OutStream(name, bufferSize, codec, this);
        }

        @Override
        public void output(ByteBuffer buffer) {
            this.output.add(buffer);
        }

        public long getBufferSize() {
            long result = 0L;
            for (ByteBuffer buf : this.output) {
                result += (long)buf.capacity();
            }
            return this.outStream.getBufferSize() + result;
        }

        public void flush(boolean reuseBuffer) throws IOException {
            this.outStream.flush(reuseBuffer);
        }

        public void clear() throws IOException {
            this.outStream.clear();
            this.output.clear();
        }

        public boolean isSuppressed() {
            return this.outStream.isSuppressed();
        }

        void spillTo(OutputStream out) throws IOException {
            for (ByteBuffer buffer : this.output) {
                out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            }
        }

        public String toString() {
            return this.outStream.toString();
        }
    }
}

