/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.RunLengthByteReader;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.io.ByteWritable;

public class LazyByteTreeReader
extends LazyTreeReader {
    private RunLengthByteReader reader = null;

    public LazyByteTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.reader = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.reader.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        return this.reader.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    @Override
    public Object next(Object previous) throws IOException {
        ByteWritable result = null;
        if (this.valuePresent) {
            result = previous == null ? new ByteWritable() : (ByteWritable)previous;
            result.set(this.reader.next());
        }
        return result;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        this.reader.skip(numNonNullValues);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

