/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.lazy.LazyNumericDictionaryTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;

class LazyLongDictionaryTreeReader
extends LazyNumericDictionaryTreeReader {
    private long latestValue = 0L;

    LazyLongDictionaryTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    protected int getNumBytes() {
        return 8;
    }

    private long readLong() throws IOException {
        this.latestValue = this.readPrimitive();
        return this.latestValue;
    }

    private long latestValue() {
        return this.latestValue;
    }

    private LongWritable createWritable(Object previous, long v) throws IOException {
        LongWritable result = null;
        result = previous == null ? new LongWritable() : (LongWritable)previous;
        result.set(v);
        return result;
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.createWritable(previous, this.latestValue());
    }

    @Override
    public long nextLong(boolean readStream) throws IOException {
        if (!readStream) {
            return this.latestValue();
        }
        if (!this.valuePresent) {
            throw new OrcLazyObject.ValueNotPresentException("Cannot materialize long.");
        }
        return this.readLong();
    }

    @Override
    public Object next(Object previous) throws IOException {
        LongWritable result = null;
        if (this.valuePresent) {
            result = this.createWritable(previous, this.readLong());
        }
        return result;
    }
}

