/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.discovery.client.CachingServiceSelector;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.discovery.client.ServiceSelectorFactory;
import java.util.concurrent.ScheduledExecutorService;

public class CachingServiceSelectorFactory
implements ServiceSelectorFactory {
    private final DiscoveryLookupClient lookupClient;
    private final ScheduledExecutorService executor;

    @Inject
    public CachingServiceSelectorFactory(DiscoveryLookupClient lookupClient, @ForDiscoveryClient ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)lookupClient, (Object)"client is null");
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.lookupClient = lookupClient;
        this.executor = executor;
    }

    @Override
    public ServiceSelector createServiceSelector(String type, ServiceSelectorConfig selectorConfig) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)selectorConfig, (Object)"selectorConfig is null");
        CachingServiceSelector serviceSelector = new CachingServiceSelector(type, selectorConfig, this.lookupClient, this.executor);
        serviceSelector.start();
        return serviceSelector;
    }
}

