/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.BitFieldReader;
import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.StreamName;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public abstract class LazyTreeReader {
    protected long rowIndexStride;
    protected long previousRow;
    protected final int columnId;
    protected long rowBaseInStripe;
    private BitFieldReader present = null;
    protected boolean valuePresent = true;
    protected long previousPresentRow;
    private long numNonNulls;
    protected int previousRowIndexEntry = -1;

    protected abstract void seek(int var1) throws IOException;

    protected long countNonNulls(long rows) throws IOException {
        if (this.present != null) {
            long result = 0L;
            for (long c = 0L; c < rows; ++c) {
                if (this.present.next() != 1) continue;
                ++result;
            }
            return result;
        }
        return rows;
    }

    protected abstract void skipRows(long var1) throws IOException;

    public void skipRowsInComplexType(long numRows) throws IOException {
        this.numNonNulls = this.countNonNulls(numRows);
        this.skipRows(this.numNonNulls);
    }

    protected abstract Object next(Object var1) throws IOException;

    public Object getInComplexType(Object previous, long row) throws IOException {
        if (this.nextIsNullInComplexType()) {
            return null;
        }
        this.previousRow = row;
        return this.next(previous);
    }

    public boolean nextIsNull(long currentRow) throws IOException {
        if (this.present != null) {
            this.seekToPresentRow(currentRow);
            boolean bl = this.valuePresent = this.present.next() == 1;
            if (this.valuePresent) {
                ++this.numNonNulls;
            } else if (currentRow == this.previousRow + 1L) {
                ++this.previousRow;
            }
        }
        return !this.valuePresent;
    }

    public boolean nextIsNullInComplexType() throws IOException {
        if (this.present != null) {
            boolean bl = this.valuePresent = this.present.next() == 1;
            if (this.valuePresent) {
                ++this.numNonNulls;
            }
        }
        return !this.valuePresent;
    }

    protected int computeRowIndexEntry(long row) {
        return this.rowIndexStride > 0L ? (int)((row - this.rowBaseInStripe - 1L) / this.rowIndexStride) : 0;
    }

    protected void seekToPresentRow(long currentRow) throws IOException {
        if (currentRow != this.previousPresentRow + 1L) {
            long rowInStripe = currentRow - this.rowBaseInStripe - 1L;
            int rowIndexEntry = this.computeRowIndexEntry(currentRow);
            if (rowIndexEntry != this.computeRowIndexEntry(this.previousPresentRow) || currentRow < this.previousPresentRow) {
                this.seek(rowIndexEntry, currentRow < this.previousPresentRow);
                this.numNonNulls = this.countNonNulls(rowInStripe - (long)rowIndexEntry * this.rowIndexStride);
            } else {
                this.numNonNulls += this.countNonNulls(currentRow - this.previousPresentRow - 1L);
            }
        }
        if ((currentRow - this.rowBaseInStripe - 1L) % this.rowIndexStride == 0L) {
            this.numNonNulls = 0L;
        }
        this.previousPresentRow = currentRow;
    }

    public LazyTreeReader(int columnId, long rowIndexStride) {
        this.columnId = columnId;
        this.rowIndexStride = rowIndexStride;
        this.previousRow = 0L;
        this.previousPresentRow = 0L;
        this.numNonNulls = 0L;
    }

    public Object get(long currentRow, Object previous) throws IOException {
        this.seekToRow(currentRow);
        return this.next(previous);
    }

    public Object createWritableFromLatest(Object previous) throws IOException {
        throw new UnsupportedOperationException("createWritableFromLatest is unsupported");
    }

    public double getDouble(long currentRow) throws IOException {
        this.seekToRow(currentRow);
        return this.nextDouble(true);
    }

    public float getFloat(long currentRow) throws IOException {
        this.seekToRow(currentRow);
        return this.nextFloat(true);
    }

    public boolean getBoolean(long currentRow) throws IOException {
        this.seekToRow(currentRow);
        return this.nextBoolean(true);
    }

    public long getLong(long currentRow) throws IOException {
        this.seekToRow(currentRow);
        return this.nextLong(true);
    }

    public int getInt(long currentRow) throws IOException {
        this.seekToRow(currentRow);
        return this.nextInt(true);
    }

    public short getShort(long currentRow) throws IOException {
        this.seekToRow(currentRow);
        return this.nextShort(true);
    }

    public double nextDouble(boolean readStream) throws IOException {
        throw new IOException("Cannot materialize double: not the right type.");
    }

    public float nextFloat(boolean readStream) throws IOException {
        throw new IOException("Cannot materialize float: not the right type.");
    }

    public boolean nextBoolean(boolean readStream) throws IOException {
        throw new IOException("Cannot materialize boolean: not the right type.");
    }

    public long nextLong(boolean readStream) throws IOException {
        throw new IOException("Cannot materialize long: not the right type.");
    }

    public int nextInt(boolean readStream) throws IOException {
        throw new IOException("Cannot materialize int: not the right type.");
    }

    public short nextShort(boolean readStream) throws IOException {
        throw new IOException("Cannot materialize short: not the right type.");
    }

    protected void seek(int rowIndexEntry, boolean backwards) throws IOException {
        if (backwards || rowIndexEntry != this.computeRowIndexEntry(this.previousRow)) {
            this.previousRowIndexEntry = rowIndexEntry;
            if (this.present != null && (backwards || rowIndexEntry != this.computeRowIndexEntry(this.previousPresentRow))) {
                this.present.seek(rowIndexEntry);
                this.previousPresentRow = this.rowBaseInStripe + (long)rowIndexEntry * this.rowIndexStride - 1L;
            }
            this.seek(rowIndexEntry);
            this.previousRow = this.rowBaseInStripe + (long)rowIndexEntry * this.rowIndexStride - 1L;
        }
    }

    protected boolean seekToRow(long currentRow) throws IOException {
        boolean seeked = false;
        if (currentRow != this.previousPresentRow) {
            this.nextIsNull(currentRow);
        }
        if (this.valuePresent) {
            if (currentRow != this.previousRow + 1L) {
                --this.numNonNulls;
                long rowInStripe = currentRow - this.rowBaseInStripe - 1L;
                int rowIndexEntry = this.computeRowIndexEntry(currentRow);
                if (this.previousRow != (long)rowIndexEntry * this.rowIndexStride - 1L && rowIndexEntry != this.computeRowIndexEntry(this.previousRow) || currentRow < this.previousRow) {
                    if (this.present == null) {
                        this.previousRowIndexEntry = rowIndexEntry;
                        this.numNonNulls = this.countNonNulls(rowInStripe - (long)rowIndexEntry * this.rowIndexStride);
                    }
                    this.seek(rowIndexEntry, currentRow <= this.previousRow);
                    this.skipRows(this.numNonNulls);
                } else {
                    if (this.present == null) {
                        this.numNonNulls = currentRow - this.previousRow - 1L;
                    }
                    this.skipRows(this.numNonNulls);
                }
                seeked = true;
            }
            this.numNonNulls = 0L;
            this.previousRow = currentRow;
        }
        return seeked;
    }

    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        if (this.present != null) {
            return this.present.loadIndeces(rowIndexEntries, startIndex);
        }
        return startIndex;
    }

    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        this.previousRow = rowBaseInStripe;
        this.previousPresentRow = rowBaseInStripe;
        this.rowBaseInStripe = rowBaseInStripe;
        this.numNonNulls = 0L;
        InStream in = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.PRESENT));
        if (in == null) {
            this.present = null;
            this.valuePresent = true;
        } else {
            this.present = new BitFieldReader(in);
        }
    }

    public void close() throws IOException {
        if (this.present != null) {
            this.present.close();
        }
    }
}

