/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.ForCassandra;
import com.facebook.presto.cassandra.RetryDriver;
import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachingCassandraSchemaProvider {
    private final String connectorId;
    private final CassandraSession session;
    private final LoadingCache<String, Map<String, String>> schemaNamesCache;
    private final LoadingCache<String, Map<String, String>> tableNamesCache;
    private final LoadingCache<PartitionListKey, List<CassandraPartition>> partitionsCache;
    private final LoadingCache<PartitionListKey, List<CassandraPartition>> partitionsCacheFull;
    private final LoadingCache<SchemaTableName, CassandraTable> tableCache;

    @Inject
    public CachingCassandraSchemaProvider(CassandraConnectorId connectorId, CassandraSession session, @ForCassandra ExecutorService executor, CassandraClientConfig cassandraClientConfig) {
        this(Objects.requireNonNull(connectorId, "connectorId is null").toString(), session, executor, Objects.requireNonNull(cassandraClientConfig, "cassandraClientConfig is null").getSchemaCacheTtl(), cassandraClientConfig.getSchemaRefreshInterval());
    }

    public CachingCassandraSchemaProvider(String connectorId, CassandraSession session, ExecutorService executor, Duration cacheTtl, Duration refreshInterval) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.session = Objects.requireNonNull(session, "cassandraSession is null");
        Objects.requireNonNull(executor, "executor is null");
        long expiresAfterWriteMillis = Objects.requireNonNull(cacheTtl, "cacheTtl is null").toMillis();
        long refreshMills = Objects.requireNonNull(refreshInterval, "refreshInterval is null").toMillis();
        this.schemaNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, Map<String, String>>(){

            public Map<String, String> load(String key) throws Exception {
                return CachingCassandraSchemaProvider.this.loadAllSchemas();
            }
        }, (Executor)executor));
        this.tableNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, Map<String, String>>(){

            public Map<String, String> load(String databaseName) throws Exception {
                return CachingCassandraSchemaProvider.this.loadAllTables(databaseName);
            }
        }, (Executor)executor));
        this.tableCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<SchemaTableName, CassandraTable>(){

            public CassandraTable load(SchemaTableName tableName) throws Exception {
                return CachingCassandraSchemaProvider.this.loadTable(tableName);
            }
        }, (Executor)executor));
        this.partitionsCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<PartitionListKey, List<CassandraPartition>>(){

            public List<CassandraPartition> load(PartitionListKey key) throws Exception {
                return CachingCassandraSchemaProvider.this.loadPartitions(key);
            }
        }, (Executor)executor));
        this.partitionsCacheFull = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<PartitionListKey, List<CassandraPartition>>(){

            public List<CassandraPartition> load(PartitionListKey key) throws Exception {
                return CachingCassandraSchemaProvider.this.loadPartitions(key);
            }
        }, (Executor)executor));
    }

    @Managed
    public void flushCache() {
        this.schemaNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.partitionsCache.invalidateAll();
        this.tableCache.invalidateAll();
    }

    public List<String> getAllSchemas() {
        return ImmutableList.copyOf(CachingCassandraSchemaProvider.getCacheValue(this.schemaNamesCache, "", RuntimeException.class).keySet());
    }

    private Map<String, String> loadAllSchemas() throws Exception {
        return (Map)RetryDriver.retry().stopOnIllegalExceptions().run("getAllSchemas", () -> Maps.uniqueIndex(this.session.getAllSchemas(), CachingCassandraSchemaProvider::toLowerCase));
    }

    public List<String> getAllTables(String databaseName) throws SchemaNotFoundException {
        return ImmutableList.copyOf(CachingCassandraSchemaProvider.getCacheValue(this.tableNamesCache, databaseName, SchemaNotFoundException.class).keySet());
    }

    private Map<String, String> loadAllTables(String databaseName) throws Exception {
        return RetryDriver.retry().stopOn(NotFoundException.class).stopOnIllegalExceptions().run("getAllTables", () -> {
            String caseSensitiveDatabaseName = this.getCaseSensitiveSchemaName(databaseName);
            if (caseSensitiveDatabaseName == null) {
                caseSensitiveDatabaseName = databaseName;
            }
            List<String> tables = this.session.getAllTables(caseSensitiveDatabaseName);
            ImmutableMap nameMap = Maps.uniqueIndex(tables, CachingCassandraSchemaProvider::toLowerCase);
            if (tables.isEmpty()) {
                this.session.getSchema(databaseName);
            }
            return nameMap;
        });
    }

    public CassandraTableHandle getTableHandle(SchemaTableName schemaTableName) {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        String schemaName = this.getCaseSensitiveSchemaName(schemaTableName.getSchemaName());
        String tableName = this.getCaseSensitiveTableName(schemaTableName);
        CassandraTableHandle tableHandle = new CassandraTableHandle(this.connectorId, schemaName, tableName);
        return tableHandle;
    }

    public String getCaseSensitiveSchemaName(String caseInsensitiveName) {
        String caseSensitiveSchemaName = CachingCassandraSchemaProvider.getCacheValue(this.schemaNamesCache, "", RuntimeException.class).get(caseInsensitiveName.toLowerCase(Locale.ENGLISH));
        return caseSensitiveSchemaName == null ? caseInsensitiveName : caseSensitiveSchemaName;
    }

    public String getCaseSensitiveTableName(SchemaTableName schemaTableName) {
        String caseSensitiveTableName = CachingCassandraSchemaProvider.getCacheValue(this.tableNamesCache, schemaTableName.getSchemaName(), SchemaNotFoundException.class).get(schemaTableName.getTableName().toLowerCase(Locale.ENGLISH));
        return caseSensitiveTableName == null ? schemaTableName.getTableName() : caseSensitiveTableName;
    }

    public CassandraTable getTable(CassandraTableHandle tableHandle) throws TableNotFoundException {
        return CachingCassandraSchemaProvider.getCacheValue(this.tableCache, tableHandle.getSchemaTableName(), TableNotFoundException.class);
    }

    public void flushTable(SchemaTableName tableName) {
        PartitionListKey partitionListKey;
        this.tableCache.asMap().remove(tableName);
        this.tableNamesCache.asMap().remove(tableName.getSchemaName());
        Iterator iterator = this.partitionsCache.asMap().keySet().iterator();
        while (iterator.hasNext()) {
            partitionListKey = (PartitionListKey)iterator.next();
            if (!partitionListKey.getTable().getTableHandle().getSchemaTableName().equals((Object)tableName)) continue;
            iterator.remove();
        }
        iterator = this.partitionsCacheFull.asMap().keySet().iterator();
        while (iterator.hasNext()) {
            partitionListKey = (PartitionListKey)iterator.next();
            if (!partitionListKey.getTable().getTableHandle().getSchemaTableName().equals((Object)tableName)) continue;
            iterator.remove();
        }
    }

    private CassandraTable loadTable(SchemaTableName tableName) throws Exception {
        return RetryDriver.retry().stopOn(NotFoundException.class).stopOnIllegalExceptions().run("getTable", () -> this.session.getTable(tableName));
    }

    public List<CassandraPartition> getAllPartitions(CassandraTable table) {
        PartitionListKey key = new PartitionListKey(table, (List<Object>)ImmutableList.of());
        return CachingCassandraSchemaProvider.getCacheValue(this.partitionsCache, key, RuntimeException.class);
    }

    public List<CassandraPartition> getPartitions(CassandraTable table, List<Object> partitionKeys) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Preconditions.checkArgument((partitionKeys.size() == table.getPartitionKeyColumns().size() ? 1 : 0) != 0);
        PartitionListKey key = new PartitionListKey(table, partitionKeys);
        return CachingCassandraSchemaProvider.getCacheValue(this.partitionsCacheFull, key, RuntimeException.class);
    }

    private List<CassandraPartition> loadPartitions(PartitionListKey key) throws Exception {
        return RetryDriver.retry().stopOnIllegalExceptions().run("getPartitions", () -> this.session.getPartitions(key.getTable(), key.getFilterPrefix()));
    }

    private static <K, V, E extends Exception> V getCacheValue(LoadingCache<K, V> cache, K key, Class<E> exceptionClass) throws E {
        try {
            return (V)cache.get(key);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)t, exceptionClass);
            throw Throwables.propagate((Throwable)t);
        }
    }

    private static String toLowerCase(String value) {
        return value.toLowerCase(Locale.ENGLISH);
    }

    private static final class PartitionListKey {
        private final CassandraTable table;
        private final List<Object> filterPrefix;

        PartitionListKey(CassandraTable table, List<Object> filterPrefix) {
            this.table = table;
            this.filterPrefix = ImmutableList.copyOf(filterPrefix);
        }

        public List<Object> getFilterPrefix() {
            return this.filterPrefix;
        }

        public CassandraTable getTable() {
            return this.table;
        }

        public int hashCode() {
            return Objects.hash(this.table, this.filterPrefix);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionListKey other = (PartitionListKey)obj;
            return Objects.equals(this.table, other.table) && Objects.equals(this.filterPrefix, other.filterPrefix);
        }
    }
}

