/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.facebook.presto.cassandra.CachingCassandraSchemaProvider;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraConnector;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraConnectorRecordSinkProvider;
import com.facebook.presto.cassandra.CassandraMetadata;
import com.facebook.presto.cassandra.CassandraPartitionManager;
import com.facebook.presto.cassandra.CassandraRecordSetProvider;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraSplitManager;
import com.facebook.presto.cassandra.CassandraThriftConnectionFactory;
import com.facebook.presto.cassandra.CassandraTokenSplitManager;
import com.facebook.presto.cassandra.ExtraColumnMetadata;
import com.facebook.presto.cassandra.ForCassandra;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class CassandraClientModule
implements Module {
    private final String connectorId;

    public CassandraClientModule(String connectorId) {
        this.connectorId = connectorId;
    }

    public void configure(Binder binder) {
        binder.bind(CassandraConnectorId.class).toInstance((Object)new CassandraConnectorId(this.connectorId));
        binder.bind(CassandraConnector.class).in(Scopes.SINGLETON);
        binder.bind(CassandraMetadata.class).in(Scopes.SINGLETON);
        binder.bind(CassandraSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraTokenSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(CassandraConnectorRecordSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(CassandraPartitionManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraThriftConnectionFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CassandraClientConfig.class);
        binder.bind(CassandraThriftConnectionFactory.class).in(Scopes.SINGLETON);
        binder.bind(CachingCassandraSchemaProvider.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(CachingCassandraSchemaProvider.class).as(ObjectNames.generatedNameOf(CachingCassandraSchemaProvider.class, (String)this.connectorId));
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(ExtraColumnMetadata.class);
    }

    @ForCassandra
    @Singleton
    @Provides
    public static ExecutorService createCachingCassandraSchemaExecutor(CassandraConnectorId clientId, CassandraClientConfig cassandraClientConfig) {
        return Executors.newFixedThreadPool(cassandraClientConfig.getMaxSchemaRefreshThreads(), Threads.daemonThreadsNamed((String)("cassandra-" + clientId + "-%s")));
    }

    @Singleton
    @Provides
    public static CassandraSession createCassandraSession(CassandraConnectorId connectorId, CassandraClientConfig config, JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(extraColumnMetadataCodec, "extraColumnMetadataCodec is null");
        Cluster.Builder clusterBuilder = Cluster.builder();
        List<String> contactPoints = Objects.requireNonNull(config.getContactPoints(), "contactPoints is null");
        Preconditions.checkArgument((!contactPoints.isEmpty() ? 1 : 0) != 0, (Object)"empty contactPoints");
        clusterBuilder.addContactPoints(contactPoints.toArray(new String[contactPoints.size()]));
        clusterBuilder.withPort(config.getNativeProtocolPort());
        clusterBuilder.withReconnectionPolicy((ReconnectionPolicy)new ExponentialReconnectionPolicy(500L, 10000L));
        clusterBuilder.withRetryPolicy(config.getRetryPolicy().getPolicy());
        SocketOptions socketOptions = new SocketOptions();
        socketOptions.setReadTimeoutMillis(Ints.checkedCast((long)config.getClientReadTimeout().toMillis()));
        socketOptions.setConnectTimeoutMillis(Ints.checkedCast((long)config.getClientConnectTimeout().toMillis()));
        if (config.getClientSoLinger() != null) {
            socketOptions.setSoLinger(config.getClientSoLinger().intValue());
        }
        clusterBuilder.withSocketOptions(socketOptions);
        if (config.getUsername() != null && config.getPassword() != null) {
            clusterBuilder.withCredentials(config.getUsername(), config.getPassword());
        }
        QueryOptions options = new QueryOptions();
        options.setFetchSize(config.getFetchSize());
        options.setConsistencyLevel(config.getConsistencyLevel());
        clusterBuilder.withQueryOptions(options);
        return new CassandraSession(connectorId.toString(), clusterBuilder, config.getFetchSizeForPartitionKeySelect(), config.getLimitForPartitionKeySelect(), extraColumnMetadataCodec);
    }
}

