/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraOutputTableHandle;
import com.facebook.presto.cassandra.CassandraRecordSink;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.spi.connector.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.inject.Inject;

public class CassandraConnectorRecordSinkProvider
implements ConnectorRecordSinkProvider {
    private final CassandraSession cassandraSession;

    @Inject
    public CassandraConnectorRecordSinkProvider(CassandraSession cassandraSession) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
    }

    public RecordSink getRecordSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraOutputTableHandle), (Object)"tableHandle is not an instance of CassandraOutputTableHandle");
        CassandraOutputTableHandle handle = (CassandraOutputTableHandle)tableHandle;
        return new CassandraRecordSink(handle, this.cassandraSession);
    }

    public RecordSink getRecordSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }
}

