/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraRecordCursor;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.FullCassandraType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CassandraRecordSet
implements RecordSet {
    private final CassandraSession cassandraSession;
    private final String schema;
    private final String cql;
    private final List<FullCassandraType> cassandraTypes;
    private final List<Type> columnTypes;

    public CassandraRecordSet(CassandraSession cassandraSession, String schema, String cql, List<CassandraColumnHandle> cassandraColumns) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.cql = Objects.requireNonNull(cql, "cql is null");
        Objects.requireNonNull(cassandraColumns, "cassandraColumns is null");
        this.cassandraTypes = CassandraRecordSet.transformList(cassandraColumns, CassandraColumnHandle::getFullType);
        this.columnTypes = CassandraRecordSet.transformList(cassandraColumns, CassandraColumnHandle::getType);
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new CassandraRecordCursor(this.cassandraSession, this.schema, this.cassandraTypes, this.cql);
    }

    private static <T, R> List<R> transformList(List<T> list, Function<T, R> function) {
        return ImmutableList.copyOf((Collection)list.stream().map(function).collect(Collectors.toList()));
    }
}

