/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraRecordSet;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraSplit;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.cassandra.util.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.MoreObjects;
import io.airlift.log.Logger;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class CassandraRecordSetProvider
implements ConnectorRecordSetProvider {
    private static final Logger log = Logger.get(CassandraRecordSetProvider.class);
    private final String connectorId;
    private final CassandraSession cassandraSession;

    @Inject
    public CassandraRecordSetProvider(CassandraConnectorId connectorId, CassandraSession cassandraSession) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        CassandraSplit cassandraSplit = Types.checkType(split, CassandraSplit.class, "split");
        List<CassandraColumnHandle> cassandraColumns = columns.stream().map(column -> Types.checkType(column, CassandraColumnHandle.class, "columnHandle")).collect(Collectors.toList());
        String selectCql = CassandraCqlUtils.selectFrom(cassandraSplit.getCassandraTableHandle(), cassandraColumns).getQueryString();
        StringBuilder sb = new StringBuilder(selectCql);
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.setLength(sb.length() - 1);
        }
        sb.append(cassandraSplit.getWhereClause());
        String cql = sb.toString();
        log.debug("Creating record set: %s", new Object[]{cql});
        return new CassandraRecordSet(this.cassandraSession, cassandraSplit.getSchema(), cql, cassandraColumns);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).toString();
    }
}

