/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.Host;
import com.facebook.presto.cassandra.CachingCassandraSchemaProvider;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraSplit;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraTableLayoutHandle;
import com.facebook.presto.cassandra.CassandraTokenSplitManager;
import com.facebook.presto.cassandra.util.HostAddressFactory;
import com.facebook.presto.cassandra.util.Types;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class CassandraSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final CassandraSession cassandraSession;
    private final CachingCassandraSchemaProvider schemaProvider;
    private final int partitionSizeForBatchSelect;
    private final CassandraTokenSplitManager tokenSplitMgr;

    @Inject
    public CassandraSplitManager(CassandraConnectorId connectorId, CassandraClientConfig cassandraClientConfig, CassandraSession cassandraSession, CachingCassandraSchemaProvider schemaProvider, CassandraTokenSplitManager tokenSplitMgr) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.schemaProvider = Objects.requireNonNull(schemaProvider, "schemaProvider is null");
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.partitionSizeForBatchSelect = cassandraClientConfig.getPartitionSizeForBatchSelect();
        this.tokenSplitMgr = tokenSplitMgr;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout) {
        CassandraPartition cassandraPartition;
        CassandraTableLayoutHandle layoutHandle = Types.checkType(layout, CassandraTableLayoutHandle.class, "layout");
        CassandraTableHandle cassandraTableHandle = layoutHandle.getTable();
        List<CassandraPartition> partitions = layoutHandle.getPartitions().get();
        Objects.requireNonNull(partitions, "partitions is null");
        if (partitions.isEmpty()) {
            return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of());
        }
        if (partitions.size() == 1 && ((cassandraPartition = partitions.get(0)).isUnpartitioned() || cassandraPartition.isIndexedColumnPredicatePushdown())) {
            CassandraTable table = this.schemaProvider.getTable(cassandraTableHandle);
            List<ConnectorSplit> splits = this.getSplitsByTokenRange(table, cassandraPartition.getPartitionId());
            return new FixedSplitSource(this.connectorId, splits);
        }
        return new FixedSplitSource(this.connectorId, this.getSplitsForPartitions(cassandraTableHandle, partitions));
    }

    private List<ConnectorSplit> getSplitsByTokenRange(CassandraTable table, String partitionId) {
        List<CassandraTokenSplitManager.TokenSplit> tokenSplits;
        String schema = table.getTableHandle().getSchemaName();
        String tableName = table.getTableHandle().getTableName();
        String tokenExpression = table.getTokenExpression();
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            tokenSplits = this.tokenSplitMgr.getSplits(schema, tableName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (CassandraTokenSplitManager.TokenSplit tokenSplit : tokenSplits) {
            String condition = CassandraSplitManager.buildTokenCondition(tokenExpression, tokenSplit.getStartToken(), tokenSplit.getEndToken());
            List<HostAddress> addresses = new HostAddressFactory().AddressNamesToHostAddressList(tokenSplit.getHosts());
            CassandraSplit split = new CassandraSplit(this.connectorId, schema, tableName, partitionId, condition, addresses);
            builder.add((Object)split);
        }
        return builder.build();
    }

    private static String buildTokenCondition(String tokenExpression, String startToken, String endToken) {
        return tokenExpression + " > " + startToken + " AND " + tokenExpression + " <= " + endToken;
    }

    private List<ConnectorSplit> getSplitsForPartitions(CassandraTableHandle cassTableHandle, List<CassandraPartition> partitions) {
        String schema = cassTableHandle.getSchemaName();
        String table = cassTableHandle.getTableName();
        HostAddressFactory hostAddressFactory = new HostAddressFactory();
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean singlePartitionKeyColumn = true;
        String partitionKeyColumnName = null;
        if (!partitions.isEmpty()) {
            boolean bl = singlePartitionKeyColumn = ((Map)partitions.get(0).getTupleDomain().getDomains().get()).size() == 1;
            if (singlePartitionKeyColumn) {
                String partitionId = partitions.get(0).getPartitionId();
                partitionKeyColumnName = partitionId.substring(0, partitionId.lastIndexOf(61) - 1);
            }
        }
        HashMap hostsToPartitionKeys = new HashMap();
        HashMap<ImmutableSet, List<HostAddress>> hostMap = new HashMap<ImmutableSet, List<HostAddress>>();
        for (CassandraPartition cassandraPartition : partitions) {
            Set<Host> hosts = this.cassandraSession.getReplicas(schema, cassandraPartition.getKeyAsByteBuffer());
            List<HostAddress> addresses = hostAddressFactory.toHostAddressList(hosts);
            if (singlePartitionKeyColumn) {
                ImmutableSet.Builder sb = ImmutableSet.builder();
                for (HostAddress address : addresses) {
                    sb.add((Object)address.getHostText());
                }
                ImmutableSet hostAddresses = sb.build();
                HashSet<String> values = (HashSet<String>)hostsToPartitionKeys.get(hostAddresses);
                if (values == null) {
                    values = new HashSet<String>();
                }
                String partitionId = cassandraPartition.getPartitionId();
                values.add(partitionId.substring(partitionId.lastIndexOf(61) + 2));
                hostsToPartitionKeys.put(hostAddresses, values);
                hostMap.put(hostAddresses, addresses);
                continue;
            }
            CassandraSplit split = new CassandraSplit(this.connectorId, schema, table, cassandraPartition.getPartitionId(), null, addresses);
            builder.add((Object)split);
        }
        if (singlePartitionKeyColumn) {
            for (Map.Entry entry : hostsToPartitionKeys.entrySet()) {
                StringBuilder sb = new StringBuilder(this.partitionSizeForBatchSelect);
                int size = 0;
                for (String value : (Set)entry.getValue()) {
                    if (size > 0) {
                        sb.append(",");
                    }
                    sb.append(value);
                    if (++size <= this.partitionSizeForBatchSelect) continue;
                    String partitionId = String.format("%s in (%s)", partitionKeyColumnName, sb.toString());
                    CassandraSplit split = new CassandraSplit(this.connectorId, schema, table, partitionId, null, (List)hostMap.get(entry.getKey()));
                    builder.add((Object)split);
                    size = 0;
                    sb.setLength(0);
                    sb.trimToSize();
                }
                if (size <= 0) continue;
                String partitionId = String.format("%s in (%s)", partitionKeyColumnName, sb.toString());
                CassandraSplit split = new CassandraSplit(this.connectorId, schema, table, partitionId, null, (List)hostMap.get(entry.getKey()));
                builder.add((Object)split);
            }
        }
        return builder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.connectorId).toString();
    }
}

