/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CassandraTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final CassandraTableHandle table;
    private final Optional<List<CassandraPartition>> partitions;

    @JsonCreator
    public CassandraTableLayoutHandle(@JsonProperty(value="table") CassandraTableHandle table) {
        this(table, Optional.empty());
    }

    public CassandraTableLayoutHandle(CassandraTableHandle table, List<CassandraPartition> partitions) {
        this(table, Optional.of(Objects.requireNonNull(partitions, "partitions is null")));
    }

    private CassandraTableLayoutHandle(CassandraTableHandle table, Optional<List<CassandraPartition>> partitions) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.partitions = Objects.requireNonNull(partitions, "partition is null");
    }

    @JsonProperty
    public CassandraTableHandle getTable() {
        return this.table;
    }

    @JsonIgnore
    public Optional<List<CassandraPartition>> getPartitions() {
        return this.partitions;
    }

    public String toString() {
        return this.table.toString();
    }
}

