/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractArrayBlock;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.ArrayElementBlockWriter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class ArrayBlockBuilder
extends AbstractArrayBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayBlockBuilder.class).instanceSize() + BlockBuilderStatus.INSTANCE_SIZE;
    private final BlockBuilderStatus blockBuilderStatus;
    private final BlockBuilder values;
    private final SliceOutput offsets;
    private final SliceOutput valueIsNull;
    private static final int OFFSET_BASE = 0;
    private int currentEntrySize;

    public ArrayBlockBuilder(BlockBuilder valuesBlock, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, valuesBlock, (SliceOutput)new DynamicSliceOutput(expectedEntries * 4), (SliceOutput)new DynamicSliceOutput(expectedEntries));
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries, expectedBytesPerEntry), (SliceOutput)new DynamicSliceOutput(expectedEntries * 4), (SliceOutput)new DynamicSliceOutput(expectedEntries));
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries), (SliceOutput)new DynamicSliceOutput(expectedEntries * 4), (SliceOutput)new DynamicSliceOutput(expectedEntries));
    }

    private ArrayBlockBuilder(BlockBuilderStatus blockBuilderStatus, BlockBuilder values, SliceOutput offsets, SliceOutput valueIsNull) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        this.values = Objects.requireNonNull(values, "values is null");
        this.offsets = Objects.requireNonNull(offsets, "offset is null");
        this.valueIsNull = Objects.requireNonNull(valueIsNull);
    }

    @Override
    public int getPositionCount() {
        return this.valueIsNull.size();
    }

    @Override
    public int getSizeInBytes() {
        return this.values.getSizeInBytes() + this.offsets.size() + this.valueIsNull.size();
    }

    @Override
    public int getRetainedSizeInBytes() {
        return INSTANCE_SIZE + this.values.getRetainedSizeInBytes() + this.offsets.getRetainedSize() + this.valueIsNull.getRetainedSize();
    }

    @Override
    protected Block getValues() {
        return this.values;
    }

    @Override
    protected Slice getOffsets() {
        return this.offsets.getUnderlyingSlice();
    }

    @Override
    protected int getOffsetBase() {
        return 0;
    }

    @Override
    protected Slice getValueIsNull() {
        return this.valueIsNull.getUnderlyingSlice();
    }

    @Override
    public void assureLoaded() {
    }

    @Override
    public BlockBuilder writeByte(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder writeShort(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder writeInt(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder writeLong(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder writeFloat(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder writeDouble(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder writeObject(Object value) {
        if (this.currentEntrySize != 0) {
            throw new IllegalStateException("Expected entry size to be exactly 0 but was " + this.currentEntrySize);
        }
        Block block = (Block)value;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                this.values.appendNull();
                continue;
            }
            block.writePositionTo(i, this.values);
            this.values.closeEntry();
        }
        ++this.currentEntrySize;
        return this;
    }

    @Override
    public ArrayElementBlockWriter beginBlockEntry() {
        if (this.currentEntrySize != 0) {
            throw new IllegalStateException("Expected current entry size to be exactly 0 but was " + this.currentEntrySize);
        }
        ++this.currentEntrySize;
        return new ArrayElementBlockWriter(this.values, this.values.getPositionCount());
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.currentEntrySize != 1) {
            throw new IllegalStateException("Expected entry size to be exactly 1 but was " + this.currentEntrySize);
        }
        this.entryAdded(false);
        this.currentEntrySize = 0;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        this.offsets.appendInt(this.values.getPositionCount());
        this.valueIsNull.appendByte(isNull ? 1 : 0);
        this.blockBuilderStatus.addBytes(5);
    }

    @Override
    public ArrayBlock build() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return new ArrayBlock(this.values.build(), this.offsets.slice(), 0, this.valueIsNull.slice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

