/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.FixedWidthBlockBuilder;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.TypeSignature;
import io.airlift.slice.Slice;

public abstract class AbstractFixedWidthType
extends AbstractType
implements FixedWidthType {
    private final int fixedSize;

    protected AbstractFixedWidthType(TypeSignature signature, Class<?> javaType, int fixedSize) {
        super(signature, javaType);
        this.fixedSize = fixedSize;
    }

    @Override
    public final int getFixedSize() {
        return this.fixedSize;
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new FixedWidthBlockBuilder(this.getFixedSize(), blockBuilderStatus, this.fixedSize == 0 ? expectedEntries : Math.min(expectedEntries, blockBuilderStatus.getMaxBlockSizeInBytes() / this.fixedSize));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.fixedSize);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new FixedWidthBlockBuilder(this.getFixedSize(), positionCount);
    }

    @Override
    public final Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }
}

