/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxHandleResolver;
import com.facebook.presto.connector.jmx.JmxMetadata;
import com.facebook.presto.connector.jmx.JmxRecordSetProvider;
import com.facebook.presto.connector.jmx.JmxSplitManager;
import com.facebook.presto.connector.jmx.JmxTransactionHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import java.util.Map;
import java.util.Objects;
import javax.management.MBeanServer;

public class JmxConnectorFactory
implements ConnectorFactory {
    private final MBeanServer mbeanServer;
    private final NodeManager nodeManager;

    public JmxConnectorFactory(MBeanServer mbeanServer, NodeManager nodeManager) {
        this.mbeanServer = Objects.requireNonNull(mbeanServer, "mbeanServer is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public String getName() {
        return "jmx";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new JmxHandleResolver();
    }

    public Connector create(final String connectorId, Map<String, String> properties) {
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
                return JmxTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
                return new JmxMetadata(connectorId, JmxConnectorFactory.this.mbeanServer);
            }

            public ConnectorSplitManager getSplitManager() {
                return new JmxSplitManager(connectorId, JmxConnectorFactory.this.nodeManager);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new JmxRecordSetProvider(JmxConnectorFactory.this.mbeanServer, JmxConnectorFactory.this.nodeManager.getCurrentNode().getNodeIdentifier());
            }
        };
    }
}

