/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxColumnHandle;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.connector.jmx.JmxTableLayoutHandle;
import com.facebook.presto.connector.jmx.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxMetadata
implements ConnectorMetadata {
    public static final String SCHEMA_NAME = "jmx";
    private final String connectorId;
    private final MBeanServer mbeanServer;

    public JmxMetadata(String connectorId, MBeanServer mbeanServer) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.mbeanServer = Objects.requireNonNull(mbeanServer, "mbeanServer is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)SCHEMA_NAME);
    }

    public JmxTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!tableName.getSchemaName().equals(SCHEMA_NAME)) {
            return null;
        }
        try {
            String canonicalName = new ObjectName(tableName.getTableName()).getCanonicalName();
            Optional<ObjectName> objectName = this.mbeanServer.queryNames(ObjectName.WILDCARD, null).stream().filter(name -> canonicalName.equalsIgnoreCase(name.getCanonicalName())).findFirst();
            if (!objectName.isPresent()) {
                return null;
            }
            MBeanInfo mbeanInfo = this.mbeanServer.getMBeanInfo(objectName.get());
            ImmutableList.Builder columns = ImmutableList.builder();
            columns.add((Object)new JmxColumnHandle(this.connectorId, "node", (Type)VarcharType.VARCHAR));
            for (MBeanAttributeInfo attribute : mbeanInfo.getAttributes()) {
                if (!attribute.isReadable()) continue;
                columns.add((Object)new JmxColumnHandle(this.connectorId, attribute.getName(), JmxMetadata.getColumnType(attribute)));
            }
            return new JmxTableHandle(this.connectorId, objectName.get().toString(), (List<JmxColumnHandle>)columns.build());
        }
        catch (JMException e) {
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return Types.checkType(tableHandle, JmxTableHandle.class, "tableHandle").getTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull != null && !schemaNameOrNull.equals(SCHEMA_NAME)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (ObjectName objectName : this.mbeanServer.queryNames(ObjectName.WILDCARD, null)) {
            tableNames.add((Object)new SchemaTableName(SCHEMA_NAME, objectName.toString().toLowerCase(Locale.ENGLISH)));
        }
        return tableNames.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JmxTableHandle jmxTableHandle = Types.checkType(tableHandle, JmxTableHandle.class, "tableHandle");
        return ImmutableMap.copyOf((Map)Maps.uniqueIndex(jmxTableHandle.getColumns(), column -> column.getColumnName().toLowerCase(Locale.ENGLISH)));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        Types.checkType(tableHandle, JmxTableHandle.class, "tableHandle");
        return Types.checkType(columnHandle, JmxColumnHandle.class, "columnHandle").getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        if (prefix.getSchemaName() != null && !prefix.getSchemaName().equals(SCHEMA_NAME)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getTableName() == null ? this.listTables(session, prefix.getSchemaName()) : ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
        for (SchemaTableName tableName : tableNames) {
            JmxTableHandle tableHandle = this.getTableHandle(session, tableName);
            columns.put((Object)tableName, (Object)tableHandle.getTableMetadata().getColumns());
        }
        return columns.build();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        JmxTableHandle handle = Types.checkType(table, JmxTableHandle.class, "table");
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new JmxTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    private static Type getColumnType(MBeanAttributeInfo attribute) {
        switch (attribute.getType()) {
            case "boolean": 
            case "java.lang.Boolean": {
                return BooleanType.BOOLEAN;
            }
            case "byte": 
            case "java.lang.Byte": 
            case "short": 
            case "java.lang.Short": 
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": {
                return BigintType.BIGINT;
            }
            case "java.lang.Number": 
            case "float": 
            case "java.lang.Float": 
            case "double": 
            case "java.lang.Double": {
                return DoubleType.DOUBLE;
            }
        }
        return VarcharType.VARCHAR;
    }
}

