/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxConnectorFactory;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.collect.ImmutableList;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.management.MBeanServer;

public class JmxPlugin
implements Plugin {
    private final MBeanServer mBeanServer;
    private NodeManager nodeManager;

    public JmxPlugin() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    public JmxPlugin(MBeanServer mBeanServer) {
        this.mBeanServer = Objects.requireNonNull(mBeanServer, "mBeanServer is null");
    }

    @Inject
    public synchronized void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public synchronized <T> List<T> getServices(Class<T> type) {
        if (type == ConnectorFactory.class) {
            return ImmutableList.of(type.cast(new JmxConnectorFactory(this.mBeanServer, this.nodeManager)));
        }
        return ImmutableList.of();
    }
}

