/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxColumnHandle;
import com.facebook.presto.connector.jmx.JmxSplit;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.connector.jmx.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxRecordSetProvider
implements ConnectorRecordSetProvider {
    private final MBeanServer mbeanServer;
    private final String nodeId;

    public JmxRecordSetProvider(MBeanServer mbeanServer, String nodeId) {
        this.mbeanServer = Objects.requireNonNull(mbeanServer, "mbeanServer is null");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
    }

    /*
     * WARNING - void declaration
     */
    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        void var8_11;
        JmxTableHandle tableHandle = Types.checkType(split, JmxSplit.class, "split").getTableHandle();
        Objects.requireNonNull(columns, "columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnHandle columnHandle : columns) {
            JmxColumnHandle jmxColumnHandle = Types.checkType(columnHandle, JmxColumnHandle.class, "column");
            builder.put((Object)jmxColumnHandle.getColumnName(), (Object)jmxColumnHandle.getColumnType());
        }
        ImmutableMap columnTypes = builder.build();
        try {
            Map<String, Object> attributes = this.getAttributes((Set<String>)columnTypes.keySet(), tableHandle);
            ArrayList<Object> row = new ArrayList<Object>();
            for (Map.Entry entry : columnTypes.entrySet()) {
                if (((String)entry.getKey()).equals("node")) {
                    row.add(this.nodeId);
                    continue;
                }
                Object value = attributes.get(entry.getKey());
                if (value == null) {
                    row.add(null);
                    continue;
                }
                Class javaType = ((Type)entry.getValue()).getJavaType();
                if (javaType == Boolean.TYPE) {
                    if (value instanceof Boolean) {
                        row.add(value);
                        continue;
                    }
                    row.add(null);
                    continue;
                }
                if (javaType == Long.TYPE) {
                    if (value instanceof Number) {
                        row.add(((Number)value).longValue());
                        continue;
                    }
                    row.add(null);
                    continue;
                }
                if (javaType == Double.TYPE) {
                    if (value instanceof Number) {
                        row.add(((Number)value).doubleValue());
                        continue;
                    }
                    row.add(null);
                    continue;
                }
                if (javaType != Slice.class) continue;
                if (value.getClass().isArray()) {
                    if (value.getClass().getComponentType() == Boolean.TYPE) {
                        row.add(Arrays.toString((boolean[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Byte.TYPE) {
                        row.add(Arrays.toString((byte[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Character.TYPE) {
                        row.add(Arrays.toString((char[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Double.TYPE) {
                        row.add(Arrays.toString((double[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Float.TYPE) {
                        row.add(Arrays.toString((float[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Integer.TYPE) {
                        row.add(Arrays.toString((int[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Long.TYPE) {
                        row.add(Arrays.toString((long[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Short.TYPE) {
                        row.add(Arrays.toString((short[])value));
                        continue;
                    }
                    row.add(Arrays.toString((Object[])value));
                    continue;
                }
                row.add(value.toString());
            }
            ImmutableList immutableList = ImmutableList.of(row);
        }
        catch (JMException e) {
            ImmutableList immutableList = ImmutableList.of();
        }
        return new InMemoryRecordSet((Collection)columnTypes.values(), (Collection)var8_11);
    }

    private Map<String, Object> getAttributes(Set<String> uniqueColumnNames, JmxTableHandle tableHandle) throws JMException {
        ObjectName objectName = new ObjectName(tableHandle.getObjectName());
        String[] columnNamesArray = uniqueColumnNames.toArray(new String[uniqueColumnNames.size()]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Attribute attribute : this.mbeanServer.getAttributes(objectName, columnNamesArray).asList()) {
            map.put(attribute.getName(), attribute.getValue());
        }
        return map;
    }
}

