/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.source.JvmMetricsSource;

public class NameNodeInstrumentation
implements MetricsSource {
    static final Log LOG = LogFactory.getLog(NameNodeInstrumentation.class);
    final String sessionId;
    final MetricsRegistry registry = new MetricsRegistry("namenode");
    final MetricMutableCounterInt numFilesCreated = this.registry.newCounter("FilesCreated", "", 0);
    final MetricMutableCounterInt numFilesAppended = this.registry.newCounter("FilesAppended", "", 0);
    final MetricMutableCounterInt numGetBlockLocations = this.registry.newCounter("GetBlockLocations", "", 0);
    final MetricMutableCounterInt numFilesRenamed = this.registry.newCounter("FilesRenamed", "", 0);
    final MetricMutableCounterInt numGetListingOps = this.registry.newCounter("GetListingOps", "", 0);
    final MetricMutableCounterInt numCreateFileOps = this.registry.newCounter("CreateFileOps", "", 0);
    final MetricMutableCounterInt numFilesDeleted = this.registry.newCounter("FilesDeleted", "Files deleted (inc. rename)", 0);
    final MetricMutableCounterInt numDeleteFileOps = this.registry.newCounter("DeleteFileOps", "", 0);
    final MetricMutableCounterInt numFileInfoOps = this.registry.newCounter("FileInfoOps", "", 0);
    final MetricMutableCounterInt numAddBlockOps = this.registry.newCounter("AddBlockOps", "", 0);
    final MetricMutableStat transactions = this.registry.newStat("Transactions");
    final MetricMutableStat syncs = this.registry.newStat("Syncs");
    final MetricMutableCounterInt transactionsBatchedInSync = this.registry.newCounter("JournalTransactionsBatchedInSync", "", 0);
    final MetricMutableStat blockReport = this.registry.newStat("blockReport");
    final MetricMutableGaugeInt safeModeTime = this.registry.newGauge("SafemodeTime", "Time spent in safe mode", 0);
    final MetricMutableGaugeInt fsImageLoadTime = this.registry.newGauge("fsImageLoadTime", "", 0);
    final MetricMutableCounterInt numFilesInGetListingOps = this.registry.newCounter("FilesInGetListingOps", "", 0);

    NameNodeInstrumentation(Configuration conf) {
        this.sessionId = conf.get("session.id");
        JvmMetricsSource.create("NameNode", this.sessionId);
        this.registry.setContext("dfs").tag("sessionId", "", this.sessionId);
    }

    public static NameNodeInstrumentation create(Configuration conf) {
        return NameNodeInstrumentation.create(conf, DefaultMetricsSystem.INSTANCE);
    }

    public static NameNodeInstrumentation create(Configuration conf, MetricsSystem ms) {
        return ms.register("NameNode", "NameNode metrics", new NameNodeInstrumentation(conf));
    }

    public void shutdown() {
    }

    public final void incrNumGetBlockLocations() {
        this.numGetBlockLocations.incr();
    }

    public final void incrNumFilesCreated() {
        this.numFilesCreated.incr();
    }

    public final void incrNumCreateFileOps() {
        this.numCreateFileOps.incr();
    }

    public final void incrNumFilesAppended() {
        this.numFilesAppended.incr();
    }

    public final void incrNumAddBlockOps() {
        this.numAddBlockOps.incr();
    }

    public final void incrNumFilesRenamed() {
        this.numFilesRenamed.incr();
    }

    public void incrFilesDeleted(int delta) {
        this.numFilesDeleted.incr(delta);
    }

    public final void incrNumDeleteFileOps() {
        this.numDeleteFileOps.incr();
    }

    public final void incrNumGetListingOps() {
        this.numGetListingOps.incr();
    }

    public final void incrNumFilesInGetListingOps(int delta) {
        this.numFilesInGetListingOps.incr(delta);
    }

    public final void incrNumFileInfoOps() {
        this.numFileInfoOps.incr();
    }

    public final void addTransaction(long latency) {
        this.transactions.add(latency);
    }

    public final void incrTransactionsBatchedInSync() {
        this.transactionsBatchedInSync.incr();
    }

    public final void addSync(long elapsed) {
        this.syncs.add(elapsed);
    }

    public final void setFsImageLoadTime(long elapsed) {
        this.fsImageLoadTime.set((int)elapsed);
    }

    public final void addBlockReport(long latency) {
        this.blockReport.add(latency);
    }

    public final void setSafeModeTime(long elapsed) {
        this.safeModeTime.set((int)elapsed);
    }

    @Override
    public void getMetrics(MetricsBuilder builder, boolean all) {
        this.registry.snapshot(builder.addRecord(this.registry.name()), all);
    }
}

