/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.TaskStatus;

public class TaskTrackerStatus
implements Writable {
    public static final Log LOG = LogFactory.getLog(TaskTrackerStatus.class);
    String trackerName;
    String host;
    int httpPort;
    int taskFailures;
    int dirFailures;
    List<TaskStatus> taskReports;
    volatile long lastSeen;
    private int maxMapTasks;
    private int maxReduceTasks;
    private TaskTrackerHealthStatus healthStatus;
    public static final int UNAVAILABLE = -1;
    private ResourceStatus resStatus;

    public TaskTrackerStatus() {
        this.taskReports = new ArrayList<TaskStatus>();
        this.resStatus = new ResourceStatus();
        this.healthStatus = new TaskTrackerHealthStatus();
    }

    TaskTrackerStatus(String trackerName, String host) {
        this();
        this.trackerName = trackerName;
        this.host = host;
    }

    public TaskTrackerStatus(String trackerName, String host, int httpPort, List<TaskStatus> taskReports, int taskFailures, int dirFailures, int maxMapTasks, int maxReduceTasks) {
        this.trackerName = trackerName;
        this.host = host;
        this.httpPort = httpPort;
        this.taskReports = new ArrayList<TaskStatus>(taskReports);
        this.taskFailures = taskFailures;
        this.dirFailures = dirFailures;
        this.maxMapTasks = maxMapTasks;
        this.maxReduceTasks = maxReduceTasks;
        this.resStatus = new ResourceStatus();
        this.healthStatus = new TaskTrackerHealthStatus();
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public String getHost() {
        return this.host;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getTaskFailures() {
        return this.taskFailures;
    }

    public int getDirFailures() {
        return this.dirFailures;
    }

    public List<TaskStatus> getTaskReports() {
        return this.taskReports;
    }

    private boolean isTaskRunning(TaskStatus taskStatus) {
        TaskStatus.State state = taskStatus.getRunState();
        return state == TaskStatus.State.RUNNING || state == TaskStatus.State.UNASSIGNED || taskStatus.inTaskCleanupPhase();
    }

    public int countMapTasks() {
        int mapCount = 0;
        for (TaskStatus ts : this.taskReports) {
            if (!ts.getIsMap() || !this.isTaskRunning(ts)) continue;
            ++mapCount;
        }
        return mapCount;
    }

    public int countOccupiedMapSlots() {
        int mapSlotsCount = 0;
        for (TaskStatus ts : this.taskReports) {
            if (!ts.getIsMap() || !this.isTaskRunning(ts)) continue;
            mapSlotsCount += ts.getNumSlots();
        }
        return mapSlotsCount;
    }

    public int getAvailableMapSlots() {
        return this.getMaxMapSlots() - this.countOccupiedMapSlots();
    }

    public int countReduceTasks() {
        int reduceCount = 0;
        for (TaskStatus ts : this.taskReports) {
            if (ts.getIsMap() || !this.isTaskRunning(ts)) continue;
            ++reduceCount;
        }
        return reduceCount;
    }

    public int countOccupiedReduceSlots() {
        int reduceSlotsCount = 0;
        for (TaskStatus ts : this.taskReports) {
            if (ts.getIsMap() || !this.isTaskRunning(ts)) continue;
            reduceSlotsCount += ts.getNumSlots();
        }
        return reduceSlotsCount;
    }

    public int getAvailableReduceSlots() {
        return this.getMaxReduceSlots() - this.countOccupiedReduceSlots();
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public int getMaxMapSlots() {
        return this.maxMapTasks;
    }

    public int getMaxReduceSlots() {
        return this.maxReduceTasks;
    }

    ResourceStatus getResourceStatus() {
        return this.resStatus;
    }

    public TaskTrackerHealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.trackerName);
        Text.writeString(out, this.host);
        out.writeInt(this.httpPort);
        out.writeInt(this.taskFailures);
        out.writeInt(this.dirFailures);
        out.writeInt(this.maxMapTasks);
        out.writeInt(this.maxReduceTasks);
        this.resStatus.write(out);
        out.writeInt(this.taskReports.size());
        for (TaskStatus taskStatus : this.taskReports) {
            TaskStatus.writeTaskStatus(out, taskStatus);
        }
        this.getHealthStatus().write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.trackerName = Text.readString(in);
        this.host = Text.readString(in);
        this.httpPort = in.readInt();
        this.taskFailures = in.readInt();
        this.dirFailures = in.readInt();
        this.maxMapTasks = in.readInt();
        this.maxReduceTasks = in.readInt();
        this.resStatus.readFields(in);
        this.taskReports.clear();
        int numTasks = in.readInt();
        for (int i = 0; i < numTasks; ++i) {
            this.taskReports.add(TaskStatus.readTaskStatus(in));
        }
        this.getHealthStatus().readFields(in);
    }

    static {
        WritableFactories.setFactory(TaskTrackerStatus.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new TaskTrackerStatus();
            }
        });
    }

    static class TaskTrackerHealthStatus
    implements Writable {
        private boolean isNodeHealthy;
        private String healthReport;
        private long lastReported;

        public TaskTrackerHealthStatus(boolean isNodeHealthy, String healthReport, long lastReported) {
            this.isNodeHealthy = isNodeHealthy;
            this.healthReport = healthReport;
            this.lastReported = lastReported;
        }

        public TaskTrackerHealthStatus() {
            this.isNodeHealthy = true;
            this.healthReport = "";
            this.lastReported = System.currentTimeMillis();
        }

        void setNodeHealthy(boolean isNodeHealthy) {
            this.isNodeHealthy = isNodeHealthy;
        }

        boolean isNodeHealthy() {
            return this.isNodeHealthy;
        }

        void setHealthReport(String healthReport) {
            this.healthReport = healthReport;
        }

        String getHealthReport() {
            return this.healthReport;
        }

        public void setLastReported(long lastReported) {
            this.lastReported = lastReported;
        }

        public long getLastReported() {
            return this.lastReported;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.isNodeHealthy = in.readBoolean();
            this.healthReport = Text.readString(in);
            this.lastReported = in.readLong();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.isNodeHealthy);
            Text.writeString(out, this.healthReport);
            out.writeLong(this.lastReported);
        }
    }

    static class ResourceStatus
    implements Writable {
        private long totalVirtualMemory = -1L;
        private long totalPhysicalMemory = -1L;
        private long mapSlotMemorySizeOnTT = -1L;
        private long reduceSlotMemorySizeOnTT = -1L;
        private long availableSpace = Long.MAX_VALUE;
        private long availableVirtualMemory = -1L;
        private long availablePhysicalMemory = -1L;
        private int numProcessors = -1;
        private long cumulativeCpuTime = -1L;
        private long cpuFrequency = -1L;
        private float cpuUsage = -1.0f;

        ResourceStatus() {
        }

        void setTotalVirtualMemory(long totalMem) {
            this.totalVirtualMemory = totalMem;
        }

        long getTotalVirtualMemory() {
            return this.totalVirtualMemory;
        }

        void setTotalPhysicalMemory(long totalRAM) {
            this.totalPhysicalMemory = totalRAM;
        }

        long getTotalPhysicalMemory() {
            return this.totalPhysicalMemory;
        }

        void setMapSlotMemorySizeOnTT(long mem) {
            this.mapSlotMemorySizeOnTT = mem;
        }

        long getMapSlotMemorySizeOnTT() {
            return this.mapSlotMemorySizeOnTT;
        }

        void setReduceSlotMemorySizeOnTT(long mem) {
            this.reduceSlotMemorySizeOnTT = mem;
        }

        long getReduceSlotMemorySizeOnTT() {
            return this.reduceSlotMemorySizeOnTT;
        }

        void setAvailableSpace(long availSpace) {
            this.availableSpace = availSpace;
        }

        long getAvailableSpace() {
            return this.availableSpace;
        }

        void setAvailableVirtualMemory(long availableMem) {
            this.availableVirtualMemory = availableMem > 0L ? availableMem : -1L;
        }

        long getAvailableVirtualMemory() {
            return this.availableVirtualMemory;
        }

        void setAvailablePhysicalMemory(long availableRAM) {
            this.availablePhysicalMemory = availableRAM > 0L ? availableRAM : -1L;
        }

        long getAvailablePhysicalMemory() {
            return this.availablePhysicalMemory;
        }

        public void setCpuFrequency(long cpuFrequency) {
            this.cpuFrequency = cpuFrequency > 0L ? cpuFrequency : -1L;
        }

        public long getCpuFrequency() {
            return this.cpuFrequency;
        }

        public void setNumProcessors(int numProcessors) {
            this.numProcessors = numProcessors > 0 ? numProcessors : -1;
        }

        public int getNumProcessors() {
            return this.numProcessors;
        }

        public void setCumulativeCpuTime(long cumulativeCpuTime) {
            this.cumulativeCpuTime = cumulativeCpuTime > 0L ? cumulativeCpuTime : -1L;
        }

        public long getCumulativeCpuTime() {
            return this.cumulativeCpuTime;
        }

        public void setCpuUsage(float cpuUsage) {
            this.cpuUsage = cpuUsage;
        }

        public float getCpuUsage() {
            return this.cpuUsage;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            WritableUtils.writeVLong(out, this.totalVirtualMemory);
            WritableUtils.writeVLong(out, this.totalPhysicalMemory);
            WritableUtils.writeVLong(out, this.availableVirtualMemory);
            WritableUtils.writeVLong(out, this.availablePhysicalMemory);
            WritableUtils.writeVLong(out, this.mapSlotMemorySizeOnTT);
            WritableUtils.writeVLong(out, this.reduceSlotMemorySizeOnTT);
            WritableUtils.writeVLong(out, this.availableSpace);
            WritableUtils.writeVLong(out, this.cumulativeCpuTime);
            WritableUtils.writeVLong(out, this.cpuFrequency);
            WritableUtils.writeVInt(out, this.numProcessors);
            out.writeFloat(this.getCpuUsage());
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.totalVirtualMemory = WritableUtils.readVLong(in);
            this.totalPhysicalMemory = WritableUtils.readVLong(in);
            this.availableVirtualMemory = WritableUtils.readVLong(in);
            this.availablePhysicalMemory = WritableUtils.readVLong(in);
            this.mapSlotMemorySizeOnTT = WritableUtils.readVLong(in);
            this.reduceSlotMemorySizeOnTT = WritableUtils.readVLong(in);
            this.availableSpace = WritableUtils.readVLong(in);
            this.cumulativeCpuTime = WritableUtils.readVLong(in);
            this.cpuFrequency = WritableUtils.readVLong(in);
            this.numProcessors = WritableUtils.readVInt(in);
            this.setCpuUsage(in.readFloat());
        }
    }
}

