/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JSPUtil;
import org.apache.hadoop.mapred.JobHistoryServer;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;
import org.codehaus.jackson.map.ObjectMapper;

public final class jobtracker_jsp
extends HttpJspBase
implements JspSourceDependent {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("d-MMM-yyyy HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private static DecimalFormat percentFormat = new DecimalFormat("##0.00");
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public void generateSummaryTable(JspWriter out, ClusterMetrics metrics, JobTracker tracker) throws IOException {
        String tasksPerNode = metrics.getTaskTrackerCount() > 0 ? percentFormat.format((double)(metrics.getMapSlotCapacity() + metrics.getReduceSlotCapacity()) / (double)metrics.getTaskTrackerCount()) : "-";
        out.print("<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n<tr><th>Running Map Tasks</th><th>Running Reduce Tasks</th><th>Total Submissions</th><th>Nodes</th><th>Occupied Map Slots</th><th>Occupied Reduce Slots</th><th>Reserved Map Slots</th><th>Reserved Reduce Slots</th><th>Map Task Capacity</th><th>Reduce Task Capacity</th><th>Avg. Tasks/Node</th><th>Blacklisted Nodes</th><th>Graylisted Nodes</th><th>Excluded Nodes</th></tr>\n");
        out.print("<tr><td>" + metrics.getRunningMaps() + "</td><td>" + metrics.getRunningReduces() + "</td><td>" + metrics.getTotalJobSubmissions() + "</td><td><a href=\"machines.jsp?type=active\">" + metrics.getTaskTrackerCount() + "</a></td><td>" + metrics.getOccupiedMapSlots() + "</td><td>" + metrics.getOccupiedReduceSlots() + "</td><td>" + metrics.getReservedMapSlots() + "</td><td>" + metrics.getReservedReduceSlots() + "</td><td>" + metrics.getMapSlotCapacity() + "</td><td>" + metrics.getReduceSlotCapacity() + "</td><td>" + tasksPerNode + "</td><td><a href=\"machines.jsp?type=blacklisted\">" + metrics.getBlackListedTaskTrackerCount() + "</a>" + "</td><td><a href=\"machines.jsp?type=graylisted\">" + metrics.getGrayListedTaskTrackerCount() + "</a>" + "</td><td><a href=\"machines.jsp?type=excluded\">" + metrics.getDecommissionedTaskTrackerCount() + "</a>" + "</td></tr></table>\n");
        out.print("<br>");
        if (tracker.hasRestarted()) {
            out.print("<span class=\"small\"><i>");
            if (tracker.hasRecovered()) {
                out.print("The JobTracker got restarted and recovered back in ");
                out.print(StringUtils.formatTime(tracker.getRecoveryDuration()));
            } else {
                out.print("The JobTracker got restarted and is still recovering");
            }
            out.print("</i></span>");
        }
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        jobtracker_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            response.setContentType("text/html");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
            out.write(10);
            out.write(10);
            out.write(10);
            out.write(10);
            out.write(10);
            out.write(10);
            out.write(10);
            out.write(10);
            String response_format = request.getParameter("format");
            if (response_format != null) {
                JobTrackerResponse theJobTrackerResponse = null;
                Object theErrorResponse = null;
                JobTracker tracker = (JobTracker)application.getAttribute("job.tracker");
                theJobTrackerResponse = new JobTrackerResponse(tracker);
                if ("json".equals(response_format)) {
                    response.setContentType("application/json");
                    ObjectMapper responseObjectMapper = new ObjectMapper();
                    out.println(responseObjectMapper.writeValueAsString((Object)(theErrorResponse == null ? theJobTrackerResponse : theErrorResponse)));
                } else {
                    response.setStatus(501);
                }
            } else {
                out.write(10);
                response.setContentType("text/html; charset=UTF-8");
                JobTracker tracker = (JobTracker)application.getAttribute("job.tracker");
                ClusterStatus status = tracker.getClusterStatus();
                ClusterMetrics metrics = tracker.getClusterMetrics();
                String trackerName = StringUtils.simpleHostname(tracker.getJobTrackerMachine());
                JobQueueInfo[] queues = tracker.getQueues();
                Vector<JobInProgress> runningJobs = tracker.runningJobs();
                Vector<JobInProgress> completedJobs = tracker.completedJobs();
                Vector<JobInProgress> failedJobs = tracker.failedJobs();
                out.write("\n\n<!DOCTYPE html>\n<html>\n<head>\n<title>");
                out.print(trackerName);
                out.write(" Hadoop Map/Reduce Administration</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<script type=\"text/javascript\" src=\"/static/jobtracker.js\"></script>\n<script type='text/javascript' src='/static/sorttable.js'></script>\n</head>\n<body>\n\n");
                JSPUtil.processButtons(request, response, tracker);
                out.write("\n\n<h1>");
                out.print(trackerName);
                out.write(" Hadoop Map/Reduce Administration</h1>\n\n<div id=\"quicklinks\">\n  <a href=\"#quicklinks\" onclick=\"toggle('quicklinks-list'); return false;\">Quick Links</a>\n  <ul id=\"quicklinks-list\">\n    <li><a href=\"#scheduling_info\">Scheduling Info</a></li>\n    <li><a href=\"#running_jobs\">Running Jobs</a></li>\n    <li><a href=\"#retired_jobs\">Retired Jobs</a></li>\n    <li><a href=\"#local_logs\">Local Logs</a></li>\n  </ul>\n</div>\n\n<b>State:</b> ");
                out.print((Object)status.getJobTrackerState());
                out.write("<br>\n<b>Started:</b> ");
                out.print((Object)new Date(tracker.getStartTime()));
                out.write("<br>\n<b>Version:</b> ");
                out.print(VersionInfo.getVersion());
                out.write(",\n                r");
                out.print(VersionInfo.getRevision());
                out.write("<br>\n<b>Compiled:</b> ");
                out.print(VersionInfo.getDate());
                out.write(" by \n                 ");
                out.print(VersionInfo.getUser());
                out.write("<br>\n<b>Identifier:</b> ");
                out.print(tracker.getTrackerIdentifier());
                out.write("<br>                 \n<b>SafeMode:</b> ");
                out.print(tracker.getSafeModeText());
                out.write("<br>                    \n<hr>\n<h2>Cluster Summary (Heap Size is ");
                out.print(StringUtils.byteDesc(Runtime.getRuntime().totalMemory()));
                out.write(47);
                out.print(StringUtils.byteDesc(Runtime.getRuntime().maxMemory()));
                out.write(")</h2>\n");
                this.generateSummaryTable(out, metrics, tracker);
                out.write("\n<hr>\n<h2 id=\"scheduling_info\">Scheduling Information</h2>\n<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\" class=\"sortable\">\n<thead style=\"font-weight: bold\">\n<tr>\n<td> Queue Name </td>\n<td> State </td>\n<td> Scheduling Information</td>\n</tr>\n</thead>\n<tbody>\n");
                for (JobQueueInfo queue : queues) {
                    String queueName = queue.getQueueName();
                    String state = queue.getQueueState();
                    String schedulingInformation = queue.getSchedulingInfo();
                    if (schedulingInformation == null || schedulingInformation.trim().equals("")) {
                        schedulingInformation = "NA";
                    }
                    out.write("\n<tr>\n<td><a href=\"jobqueue_details.jsp?queueName=");
                    out.print(queueName);
                    out.write(34);
                    out.write(62);
                    out.print(queueName);
                    out.write("</a></td>\n<td>");
                    out.print(state);
                    out.write("</td>\n<td>");
                    out.print(HtmlQuoting.quoteHtmlChars(schedulingInformation).replaceAll("\n", "<br/>"));
                    out.write("\n</td>\n</tr>\n");
                }
                out.write("\n</tbody>\n</table>\n<hr/>\n<b>Filter (Jobid, Priority, User, Name)</b> <input type=\"text\" id=\"filter\" onkeyup=\"applyfilter()\"> <br>\n<span class=\"small\">Example: 'user:smith 3200' will filter by 'smith' only in the user field and '3200' in all fields</span>\n<hr>\n\n<h2 id=\"running_jobs\">Running Jobs</h2>\n");
                out.print(JSPUtil.generateJobTable("Running", runningJobs, 30, 0, tracker.conf));
                out.write("\n<hr>\n\n");
                if (completedJobs.size() > 0) {
                    out.print("<h2 id=\"completed_jobs\">Completed Jobs</h2>");
                    out.print(JSPUtil.generateJobTable("Completed", completedJobs, 0, runningJobs.size(), tracker.conf));
                    out.print("<hr>");
                }
                out.write(10);
                out.write(10);
                if (failedJobs.size() > 0) {
                    out.print("<h2 id=\"failed_jobs\">Failed Jobs</h2>");
                    out.print(JSPUtil.generateJobTable("Failed", failedJobs, 0, runningJobs.size() + completedJobs.size(), tracker.conf));
                    out.print("<hr>");
                }
                out.write("\n\n<h2 id=\"retired_jobs\">Retired Jobs</h2>\n");
                out.print(JSPUtil.generateRetiredJobTable(tracker, runningJobs.size() + completedJobs.size() + failedJobs.size()));
                out.write("\n<hr>\n\n<h2 id=\"local_logs\">Local Logs</h2>\n<a href=\"logs/\">Log</a> directory,\n<a href=\"");
                out.print(JobHistoryServer.getHistoryUrlPrefix(tracker.conf));
                out.write("/jobhistoryhome.jsp\">\nJob Tracker History</a>\n\n");
                out.println(ServletUtil.htmlFooter());
                out.write(10);
            }
            out.write(10);
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof SkipPageException)) {
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
    }

    public static class JobTrackerResponse {
        private final JobTrackerMetaInfo metaInfo;
        private final JobTrackerClusterSummary clusterSummary;
        private final Collection<JobSummaryInfo> runningJobsSummaryInfo;
        private final Collection<JobSummaryInfo> completedJobsSummaryInfo;
        private final Collection<JobSummaryInfo> failedJobsSummaryInfo;

        private void populateJobsSummaryInfo(Collection<JobInProgress> jips, Collection<JobSummaryInfo> jsis) {
            for (JobInProgress jip : jips) {
                jsis.add(new JobSummaryInfo(jip));
            }
        }

        JobTrackerResponse(JobTracker jt) {
            this.metaInfo = new JobTrackerMetaInfo(jt);
            this.clusterSummary = new JobTrackerClusterSummary(jt);
            Vector<JobInProgress> runningJobs = jt.runningJobs();
            this.runningJobsSummaryInfo = runningJobs.size() > 0 ? new ArrayList() : null;
            this.populateJobsSummaryInfo(runningJobs, this.runningJobsSummaryInfo);
            Vector<JobInProgress> completedJobs = jt.completedJobs();
            this.completedJobsSummaryInfo = completedJobs.size() > 0 ? new ArrayList() : null;
            this.populateJobsSummaryInfo(completedJobs, this.completedJobsSummaryInfo);
            Vector<JobInProgress> failedJobs = jt.failedJobs();
            this.failedJobsSummaryInfo = failedJobs.size() > 0 ? new ArrayList() : null;
            this.populateJobsSummaryInfo(failedJobs, this.failedJobsSummaryInfo);
        }

        public JobTrackerMetaInfo getMetaInfo() {
            return this.metaInfo;
        }

        public JobTrackerClusterSummary getClusterSummary() {
            return this.clusterSummary;
        }

        public Collection<JobSummaryInfo> getRunningJobsSummaryInfo() {
            return this.runningJobsSummaryInfo;
        }

        public Collection<JobSummaryInfo> getCompletedJobsSummaryInfo() {
            return this.completedJobsSummaryInfo;
        }

        public Collection<JobSummaryInfo> getFailedJobsSummaryInfo() {
            return this.failedJobsSummaryInfo;
        }

        public static class JobSummaryInfo {
            private final String jobId;
            private final String jobName;
            private final String userName;
            private final String jobPriority;
            private final JobTaskStats mapStats;
            private final JobTaskStats reduceStats;
            private final String jobSchedulingInfo;

            JobSummaryInfo(JobInProgress jip) {
                JobProfile jobProfile = jip.getProfile();
                this.jobId = jobProfile.getJobID().toString();
                this.jobName = jobProfile.getJobName();
                this.userName = jobProfile.getUser();
                this.jobPriority = jip.getPriority().toString();
                JobStatus jobStatus = jip.getStatus();
                this.mapStats = new JobTaskStats(jip.finishedMaps(), jip.desiredMaps(), jobStatus.mapProgress() * 100.0f);
                this.reduceStats = new JobTaskStats(jip.finishedReduces(), jip.desiredReduces(), jobStatus.reduceProgress() * 100.0f);
                this.jobSchedulingInfo = jip.getStatus().getSchedulingInfo();
            }

            public String getJobId() {
                return this.jobId;
            }

            public String getJobName() {
                return this.jobName;
            }

            public String getUserName() {
                return this.userName;
            }

            public String getJobPriority() {
                return this.jobPriority;
            }

            public JobTaskStats getMapStats() {
                return this.mapStats;
            }

            public JobTaskStats getReduceStats() {
                return this.reduceStats;
            }

            public String getJobSchedulingInfo() {
                return this.jobSchedulingInfo;
            }

            public static class JobTaskStats {
                private final int numCompleted;
                private final int numTotal;
                private final float completionPercentage;

                JobTaskStats(int nc, int nt, float cp) {
                    this.numCompleted = nc;
                    this.numTotal = nt;
                    this.completionPercentage = cp;
                }

                public int getNumCompleted() {
                    return this.numCompleted;
                }

                public int getNumTotal() {
                    return this.numTotal;
                }

                public float getCompletionPercentage() {
                    return this.completionPercentage;
                }
            }
        }

        public static class JobTrackerClusterSummary {
            private final long usedHeapMemoryBytes = Runtime.getRuntime().totalMemory();
            private final long totalHeapMemoryBytes = Runtime.getRuntime().maxMemory();
            private final long numTotalTaskTrackers;
            private final long numBlackListedTaskTrackers;
            private final long numGrayListedTaskTrackers;
            private final long numDecommissionedTaskTrackers;
            private final long runningMapTasks;
            private final long runningReduceTasks;
            private final long totalJobSubmissions;
            private final long occupiedMapSlots;
            private final long occupiedReduceSlots;
            private final long reservedMapSlots;
            private final long reservedReduceSlots;
            private final long mapTaskCapacity;
            private final long reduceTaskCapacity;
            private final float avgTasksPerTaskTracker;

            JobTrackerClusterSummary(JobTracker jt) {
                ClusterMetrics metrics = jt.getClusterMetrics();
                this.numTotalTaskTrackers = metrics.getTaskTrackerCount();
                this.numBlackListedTaskTrackers = metrics.getBlackListedTaskTrackerCount();
                this.numGrayListedTaskTrackers = metrics.getGrayListedTaskTrackerCount();
                this.numDecommissionedTaskTrackers = metrics.getDecommissionedTaskTrackerCount();
                this.runningMapTasks = metrics.getRunningMaps();
                this.runningReduceTasks = metrics.getRunningReduces();
                this.totalJobSubmissions = metrics.getTotalJobSubmissions();
                this.occupiedMapSlots = metrics.getOccupiedMapSlots();
                this.occupiedReduceSlots = metrics.getOccupiedReduceSlots();
                this.reservedMapSlots = metrics.getReservedMapSlots();
                this.reservedReduceSlots = metrics.getReservedReduceSlots();
                this.mapTaskCapacity = metrics.getMapSlotCapacity();
                this.reduceTaskCapacity = metrics.getReduceSlotCapacity();
                this.avgTasksPerTaskTracker = this.numTotalTaskTrackers > 0L ? (float)((double)(this.mapTaskCapacity + this.reduceTaskCapacity) / (double)this.numTotalTaskTrackers) : 0.0f;
            }

            public long getUsedHeapMemoryBytes() {
                return this.usedHeapMemoryBytes;
            }

            public long getTotalHeapMemoryBytes() {
                return this.totalHeapMemoryBytes;
            }

            public long getNumTotalTaskTrackers() {
                return this.numTotalTaskTrackers;
            }

            public long getNumBlackListedTaskTrackers() {
                return this.numBlackListedTaskTrackers;
            }

            public long getNumGrayListedTaskTrackers() {
                return this.numGrayListedTaskTrackers;
            }

            public long getNumDecommissionedTaskTrackers() {
                return this.numDecommissionedTaskTrackers;
            }

            public long getRunningMapTasks() {
                return this.runningMapTasks;
            }

            public long getRunningReduceTasks() {
                return this.runningReduceTasks;
            }

            public long getTotalJobSubmissions() {
                return this.totalJobSubmissions;
            }

            public long getOccupiedMapSlots() {
                return this.occupiedMapSlots;
            }

            public long getOccupiedReduceSlots() {
                return this.occupiedReduceSlots;
            }

            public long getReservedMapSlots() {
                return this.reservedMapSlots;
            }

            public long getReservedReduceSlots() {
                return this.reservedReduceSlots;
            }

            public long getMapTaskCapacity() {
                return this.mapTaskCapacity;
            }

            public long getReduceTaskCapacity() {
                return this.reduceTaskCapacity;
            }

            public float getAvgTasksPerTaskTracker() {
                return this.avgTasksPerTaskTracker;
            }
        }

        public static class JobTrackerMetaInfo {
            private final String jobTrackerName;
            private final String status;
            private final String startTimestamp;
            private final String version;
            private final String compilationInfo;
            private final String identifier;
            private final String safeModeStatus;
            private final boolean hasRestarted;
            private final boolean hasRecovered;
            private final long recoveryDurationSecs;

            JobTrackerMetaInfo(JobTracker jt) {
                this.jobTrackerName = StringUtils.simpleHostname(jt.getJobTrackerMachine());
                this.status = jt.getClusterStatus().getJobTrackerState().toString();
                this.startTimestamp = dateFormat.format(new Date(jt.getStartTime()));
                this.version = VersionInfo.getVersion() + ", revision " + VersionInfo.getRevision();
                this.compilationInfo = VersionInfo.getDate() + " by " + VersionInfo.getUser();
                this.identifier = jt.getTrackerIdentifier();
                this.safeModeStatus = jt.getSafeModeText();
                this.hasRestarted = jt.hasRestarted();
                this.hasRecovered = jt.hasRecovered();
                this.recoveryDurationSecs = this.hasRestarted && this.hasRecovered ? jt.getRecoveryDuration() / 1000L : 0L;
            }

            public String getJobTrackerName() {
                return this.jobTrackerName;
            }

            public String getStatus() {
                return this.status;
            }

            public String getStartTimestamp() {
                return this.startTimestamp;
            }

            public String getVersion() {
                return this.version;
            }

            public String getCompilationInfo() {
                return this.compilationInfo;
            }

            public String getIdentifier() {
                return this.identifier;
            }

            public String getSafeModeStatus() {
                return this.safeModeStatus;
            }

            public boolean getHasRestarted() {
                return this.hasRestarted;
            }

            public boolean getHasRecovered() {
                return this.hasRecovered;
            }

            public long getRecoveryDurationSecs() {
                return this.recoveryDurationSecs;
            }
        }
    }

    public static class ErrorResponse {
        private final long errorCode;
        private final String errorDescription;

        ErrorResponse(long ec, String ed) {
            this.errorCode = ec;
            this.errorDescription = ed;
        }

        public long getErrorCode() {
            return this.errorCode;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }
    }
}

