/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.security.UserGroupInformation;

public class JobSubmissionFiles {
    private static final Log LOG = LogFactory.getLog(JobSubmissionFiles.class);
    public static final FsPermission JOB_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission JOB_FILE_PERMISSION = FsPermission.createImmutable((short)420);

    public static Path getJobSplitFile(Path jobSubmissionDir) {
        return new Path(jobSubmissionDir, "job.split");
    }

    public static Path getJobSplitMetaFile(Path jobSubmissionDir) {
        return new Path(jobSubmissionDir, "job.splitmetainfo");
    }

    public static Path getJobConfPath(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "job.xml");
    }

    public static Path getJobJar(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "job.jar");
    }

    public static Path getJobDistCacheFiles(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "files");
    }

    public static Path getJobDistCacheArchives(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "archives");
    }

    public static Path getJobDistCacheLibjars(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "libjars");
    }

    public static Path getStagingDir(JobClient client, Configuration conf) throws IOException, InterruptedException {
        Path stagingArea = client.getStagingAreaDir();
        FileSystem fs = stagingArea.getFileSystem(conf);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        String realUser = ugi.getShortUserName();
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (fs.exists(stagingArea)) {
            FileStatus fsStatus = fs.getFileStatus(stagingArea);
            String owner = fsStatus.getOwner();
            if (!owner.equals(currentUser) && !owner.equals(realUser)) {
                throw new IOException("The ownership on the staging directory " + stagingArea + " is not as expected. " + "It is owned by " + owner + ". The directory must " + "be owned by the submitter " + currentUser + " or " + "by " + realUser);
            }
            if (!fsStatus.getPermission().equals(JOB_DIR_PERMISSION)) {
                LOG.info("Permissions on staging directory " + stagingArea + " are " + "incorrect: " + fsStatus.getPermission() + ". Fixing permissions " + "to correct value " + JOB_DIR_PERMISSION);
                fs.setPermission(stagingArea, JOB_DIR_PERMISSION);
            }
        } else {
            fs.mkdirs(stagingArea, new FsPermission(JOB_DIR_PERMISSION));
        }
        return stagingArea;
    }
}

