/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeans {
    private static final Log LOG = LogFactory.getLog(MBeans.class);

    public static ObjectName register(String serviceName, String nameName, Object theMbean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = MBeans.getMBeanName(serviceName, nameName);
        try {
            mbs.registerMBean(theMbean, name);
            return name;
        }
        catch (InstanceAlreadyExistsException ie) {
            LOG.warn(name, ie);
        }
        catch (Exception e) {
            LOG.warn("Error registering " + name, e);
        }
        return null;
    }

    public static void unregister(ObjectName mbeanName) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbeanName == null) {
            return;
        }
        try {
            mbs.unregisterMBean(mbeanName);
        }
        catch (InstanceNotFoundException e) {
            LOG.warn(mbeanName, e);
        }
        catch (Exception e) {
            LOG.warn("Error unregistering " + mbeanName, e);
        }
    }

    private static ObjectName getMBeanName(String serviceName, String nameName) {
        ObjectName name = null;
        String nameStr = "Hadoop:service=" + serviceName + ",name=" + nameName;
        try {
            name = new ObjectName(nameStr);
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Error creating MBean object name: " + nameStr, e);
        }
        return name;
    }
}

