/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.util.Shell;

public class ShellBasedUnixGroupsMapping
implements GroupMappingServiceProvider {
    private static final Log LOG = LogFactory.getLog(ShellBasedUnixGroupsMapping.class);

    @Override
    public List<String> getGroups(String user) throws IOException {
        return ShellBasedUnixGroupsMapping.getUnixGroups(user);
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    private static List<String> getUnixGroups(String user) throws IOException {
        String result = "";
        try {
            result = Shell.execCommand(Shell.getGroupsForUserCommand(user));
        }
        catch (Shell.ExitCodeException e) {
            LOG.warn("got exception trying to get groups for user " + user, e);
        }
        StringTokenizer tokenizer = new StringTokenizer(result);
        LinkedList<String> groups = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
        return groups;
    }
}

