/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageIndexer;
import com.facebook.presto.spi.type.Type;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public class GroupByHashPageIndexer
implements PageIndexer {
    private final GroupByHash hash;

    public GroupByHashPageIndexer(List<? extends Type> hashTypes) {
        this(GroupByHash.createGroupByHash(hashTypes, IntStream.range(0, hashTypes.size()).toArray(), Optional.empty(), Optional.empty(), 20, false));
    }

    public GroupByHashPageIndexer(GroupByHash hash) {
        this.hash = Objects.requireNonNull(hash, "hash is null");
    }

    public int[] indexPage(Page page) {
        GroupByIdBlock groupIds = this.hash.getGroupIds(page);
        int[] indexes = new int[page.getPositionCount()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Ints.checkedCast((long)groupIds.getGroupId(i));
        }
        return indexes;
    }

    public int getMaxIndex() {
        return this.hash.getGroupCount() - 1;
    }
}

