/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.transaction.TransactionManager;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class DropViewTask
implements DataDefinitionTask<DropView> {
    @Override
    public String getName() {
        return "DROP VIEW";
    }

    @Override
    public CompletableFuture<?> execute(DropView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine) {
        QualifiedObjectName name;
        Session session = stateMachine.getSession();
        Optional<ViewDefinition> view = metadata.getView(session, name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName()));
        if (!view.isPresent()) {
            if (!statement.isExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "View '%s' does not exist", name);
            }
            return CompletableFuture.completedFuture(null);
        }
        accessControl.checkCanDropView(session.getRequiredTransactionId(), session.getIdentity(), name);
        metadata.dropView(session, name);
        return CompletableFuture.completedFuture(null);
    }
}

