/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.spi.Page;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class PageSplitterUtil {
    private PageSplitterUtil() {
    }

    public static List<Page> splitPage(Page page, long maxPageSizeInBytes) {
        Preconditions.checkArgument((page.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"page is empty");
        Preconditions.checkArgument((maxPageSizeInBytes > 0L ? 1 : 0) != 0, (Object)"maxPageSizeInBytes must be > 0");
        if (page.getSizeInBytes() <= maxPageSizeInBytes || page.getPositionCount() == 1) {
            return ImmutableList.of((Object)page);
        }
        ImmutableList.Builder outputPages = ImmutableList.builder();
        int positionCount = page.getPositionCount();
        int half = positionCount / 2;
        Page splitPage1 = page.getRegion(0, half);
        outputPages.addAll(PageSplitterUtil.splitPage(splitPage1, maxPageSizeInBytes));
        Page splitPage2 = page.getRegion(half, positionCount - half);
        outputPages.addAll(PageSplitterUtil.splitPage(splitPage2, maxPageSizeInBytes));
        return outputPages.build();
    }
}

