/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.execution.QueryQueueDefinition;
import com.facebook.presto.execution.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class QueryQueueRule
implements ResourceGroupSelector {
    @Nullable
    private final Pattern userRegex;
    @Nullable
    private final Pattern sourceRegex;
    private final Map<String, Pattern> sessionPropertyRegexes;
    private final List<QueryQueueDefinition> queues;

    QueryQueueRule(@Nullable Pattern userRegex, @Nullable Pattern sourceRegex, Map<String, Pattern> sessionPropertyRegexes, List<QueryQueueDefinition> queues) {
        this.userRegex = userRegex;
        this.sourceRegex = sourceRegex;
        this.sessionPropertyRegexes = ImmutableMap.copyOf(Objects.requireNonNull(sessionPropertyRegexes, "sessionPropertyRegexes is null"));
        Objects.requireNonNull(queues, "queues is null");
        Preconditions.checkArgument((!queues.isEmpty() ? 1 : 0) != 0, (Object)"queues is empty");
        this.queues = ImmutableList.copyOf(queues);
    }

    public static QueryQueueRule createRule(@Nullable Pattern userRegex, @Nullable Pattern sourceRegex, Map<String, Pattern> sessionPropertyRegexes, List<String> queueKeys, Map<String, QueryQueueDefinition> definedQueues) {
        ImmutableList.Builder queues = ImmutableList.builder();
        for (String key : queueKeys) {
            if (!definedQueues.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Undefined queue %s. Defined queues are %s", key, definedQueues.keySet()));
            }
            queues.add((Object)definedQueues.get(key));
        }
        return new QueryQueueRule(userRegex, sourceRegex, sessionPropertyRegexes, (List<QueryQueueDefinition>)queues.build());
    }

    @Override
    public Optional<List<QueryQueueDefinition>> match(Statement statement, SessionRepresentation session) {
        String source;
        if (this.userRegex != null && !this.userRegex.matcher(session.getUser()).matches()) {
            return Optional.empty();
        }
        if (this.sourceRegex != null && !this.sourceRegex.matcher(source = session.getSource().orElse("")).matches()) {
            return Optional.empty();
        }
        for (Map.Entry<String, Pattern> entry : this.sessionPropertyRegexes.entrySet()) {
            String value = session.getSystemProperties().getOrDefault(entry.getKey(), "");
            if (entry.getValue().matcher(value).matches()) continue;
            return Optional.empty();
        }
        return Optional.of(this.queues);
    }

    List<QueryQueueDefinition> getQueues() {
        return this.queues;
    }
}

