/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class QueryStateMachine {
    private static final Logger log = Logger.get(QueryStateMachine.class);
    private final DateTime createTime = DateTime.now();
    private final long createNanos = System.nanoTime();
    private final AtomicLong endNanos = new AtomicLong();
    private final QueryId queryId;
    private final String query;
    private final Session session;
    private final URI self;
    private final boolean autoCommit;
    private final TransactionManager transactionManager;
    private final AtomicReference<VersionedMemoryPoolId> memoryPool = new AtomicReference<VersionedMemoryPoolId>(new VersionedMemoryPoolId(LocalMemoryManager.GENERAL_POOL, 0L));
    private final AtomicLong peakMemory = new AtomicLong();
    private final AtomicLong currentMemory = new AtomicLong();
    private final AtomicReference<DateTime> lastHeartbeat = new AtomicReference<DateTime>(DateTime.now());
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> endTime = new AtomicReference();
    private final AtomicReference<Duration> queuedTime = new AtomicReference();
    private final AtomicReference<Duration> analysisTime = new AtomicReference();
    private final AtomicReference<Duration> distributedPlanningTime = new AtomicReference();
    private final AtomicReference<Long> finishingStartNanos = new AtomicReference();
    private final AtomicReference<Duration> finishingTime = new AtomicReference();
    private final AtomicReference<Duration> totalPlanningTime = new AtomicReference();
    private final StateMachine<QueryState> queryState;
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final AtomicReference<TransactionId> startedTransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final AtomicReference<String> updateType = new AtomicReference();
    private final AtomicReference<ExecutionFailureInfo> failureCause = new AtomicReference();
    private final AtomicReference<List<String>> outputFieldNames = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final AtomicReference<Set<Input>> inputs = new AtomicReference<ImmutableSet>(ImmutableSet.of());

    private QueryStateMachine(QueryId queryId, String query, Session session, URI self, boolean autoCommit, TransactionManager transactionManager, Executor executor) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.self = Objects.requireNonNull(self, "self is null");
        this.autoCommit = autoCommit;
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.queryState = new StateMachine<QueryState>("query " + query, executor, QueryState.QUEUED, QueryState.TERMINAL_QUERY_STATES);
    }

    public static QueryStateMachine begin(QueryId queryId, String query, Session session, URI self, boolean transactionControl, TransactionManager transactionManager, Executor executor) {
        Session querySession;
        boolean autoCommit;
        session.getTransactionId().ifPresent(transactionControl ? transactionManager::trySetActive : transactionManager::checkAndSetActive);
        boolean bl = autoCommit = !session.getTransactionId().isPresent() && !transactionControl;
        if (autoCommit) {
            TransactionId transactionId = transactionManager.beginTransaction(true);
            querySession = session.withTransactionId(transactionId);
        } else {
            querySession = session;
        }
        QueryStateMachine queryStateMachine = new QueryStateMachine(queryId, query, querySession, self, autoCommit, transactionManager, executor);
        queryStateMachine.addStateChangeListener(newState -> log.debug("Query %s is %s", new Object[]{queryId, newState}));
        queryStateMachine.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                session.getTransactionId().ifPresent(transactionManager::trySetInactive);
            }
        });
        return queryStateMachine;
    }

    public static QueryStateMachine failed(QueryId queryId, String query, Session session, URI self, TransactionManager transactionManager, Executor executor, Throwable throwable) {
        QueryStateMachine queryStateMachine = new QueryStateMachine(queryId, query, session, self, false, transactionManager, executor);
        queryStateMachine.transitionToFailed(throwable);
        return queryStateMachine;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public long getPeakMemoryInBytes() {
        return this.peakMemory.get();
    }

    public void updateMemoryUsage(long deltaMemoryInBytes) {
        long currentMemoryValue = this.currentMemory.addAndGet(deltaMemoryInBytes);
        if (currentMemoryValue > this.peakMemory.get()) {
            this.peakMemory.updateAndGet(x -> currentMemoryValue > x ? currentMemoryValue : x);
        }
    }

    public QueryInfo getQueryInfoWithoutDetails() {
        return this.getQueryInfo(null);
    }

    public QueryInfo getQueryInfo(StageInfo rootStage) {
        ExecutionFailureInfo failureCause;
        QueryState state = this.queryState.get();
        Duration elapsedTime = this.endNanos.get() != 0L ? new Duration((double)(this.endNanos.get() - this.createNanos), TimeUnit.NANOSECONDS) : Duration.nanosSince((long)this.createNanos);
        FailureInfo failureInfo = null;
        ErrorCode errorCode = null;
        if (state != QueryState.FINISHED && (failureCause = this.failureCause.get()) != null) {
            failureInfo = failureCause.toFailureInfo();
            errorCode = failureCause.getErrorCode();
        }
        int totalTasks = 0;
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int completedDrivers = 0;
        long cumulativeMemory = 0L;
        long totalMemoryReservation = 0L;
        long peakMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalUserTime = 0L;
        long totalBlockedTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        boolean fullyBlocked = rootStage != null;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        if (rootStage != null) {
            for (StageInfo stageInfo : StageInfo.getAllStages(rootStage)) {
                PlanFragment plan;
                StageStats stageStats = stageInfo.getStageStats();
                totalTasks += stageStats.getTotalTasks();
                runningTasks += stageStats.getRunningTasks();
                completedTasks += stageStats.getCompletedTasks();
                totalDrivers += stageStats.getTotalDrivers();
                queuedDrivers += stageStats.getQueuedDrivers();
                runningDrivers += stageStats.getRunningDrivers();
                completedDrivers += stageStats.getCompletedDrivers();
                cumulativeMemory = (long)((double)cumulativeMemory + stageStats.getCumulativeMemory());
                totalMemoryReservation += stageStats.getTotalMemoryReservation().toBytes();
                peakMemoryReservation = this.getPeakMemoryInBytes();
                totalScheduledTime += stageStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
                totalCpuTime += stageStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
                totalUserTime += stageStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
                totalBlockedTime += stageStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
                if (!stageInfo.getState().isDone()) {
                    fullyBlocked &= stageStats.isFullyBlocked();
                    blockedReasons.addAll(stageStats.getBlockedReasons());
                }
                if ((plan = stageInfo.getPlan()) == null || !(plan.getPartitionedSourceNode() instanceof TableScanNode)) continue;
                rawInputDataSize += stageStats.getRawInputDataSize().toBytes();
                rawInputPositions += stageStats.getRawInputPositions();
                processedInputDataSize += stageStats.getProcessedInputDataSize().toBytes();
                processedInputPositions += stageStats.getProcessedInputPositions();
            }
            StageStats outputStageStats = rootStage.getStageStats();
            outputDataSize += outputStageStats.getOutputDataSize().toBytes();
            outputPositions += outputStageStats.getOutputPositions();
        }
        QueryStats queryStats = new QueryStats(this.createTime, this.executionStartTime.get(), this.lastHeartbeat.get(), this.endTime.get(), elapsedTime.convertToMostSuccinctTimeUnit(), this.queuedTime.get(), this.analysisTime.get(), this.distributedPlanningTime.get(), this.totalPlanningTime.get(), this.finishingTime.get(), totalTasks, runningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, cumulativeMemory, new DataSize((double)totalMemoryReservation, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), new DataSize((double)peakMemoryReservation, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked, blockedReasons, new DataSize((double)rawInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), rawInputPositions, new DataSize((double)processedInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), processedInputPositions, new DataSize((double)outputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), outputPositions);
        return new QueryInfo(this.queryId, this.session.toSessionRepresentation(), state, this.memoryPool.get().getId(), QueryStateMachine.isScheduled(rootStage), this.self, this.outputFieldNames.get(), this.query, queryStats, this.setSessionProperties, this.resetSessionProperties, Optional.ofNullable(this.startedTransactionId.get()), this.clearTransactionId.get(), this.updateType.get(), rootStage, failureInfo, errorCode, this.inputs.get());
    }

    public VersionedMemoryPoolId getMemoryPool() {
        return this.memoryPool.get();
    }

    public void setMemoryPool(VersionedMemoryPoolId memoryPool) {
        this.memoryPool.set(Objects.requireNonNull(memoryPool, "memoryPool is null"));
    }

    public void setOutputFieldNames(List<String> outputFieldNames) {
        Objects.requireNonNull(outputFieldNames, "outputFieldNames is null");
        this.outputFieldNames.set((List<String>)ImmutableList.copyOf(outputFieldNames));
    }

    public void setInputs(List<Input> inputs) {
        Objects.requireNonNull(inputs, "inputs is null");
        this.inputs.set((Set<Input>)ImmutableSet.copyOf(inputs));
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public void addSetSessionProperties(String key, String value) {
        this.setSessionProperties.put(Objects.requireNonNull(key, "key is null"), Objects.requireNonNull(value, "value is null"));
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public void addResetSessionProperties(String name) {
        this.resetSessionProperties.add(Objects.requireNonNull(name, "name is null"));
    }

    public void setStartedTransactionId(TransactionId startedTransactionId) {
        Preconditions.checkArgument((!this.clearTransactionId.get() ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.startedTransactionId.set(startedTransactionId);
    }

    public void clearTransactionId() {
        Preconditions.checkArgument((this.startedTransactionId.get() == null ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.clearTransactionId.set(true);
    }

    public void setUpdateType(String updateType) {
        this.updateType.set(updateType);
    }

    public QueryState getQueryState() {
        return this.queryState.get();
    }

    public boolean isDone() {
        return this.queryState.get().isDone();
    }

    public boolean transitionToPlanning() {
        this.queuedTime.compareAndSet(null, Duration.nanosSince((long)this.createNanos).convertToMostSuccinctTimeUnit());
        return this.queryState.compareAndSet(QueryState.QUEUED, QueryState.PLANNING);
    }

    public boolean transitionToStarting() {
        Duration durationSinceCreation = Duration.nanosSince((long)this.createNanos).convertToMostSuccinctTimeUnit();
        this.queuedTime.compareAndSet(null, durationSinceCreation);
        this.totalPlanningTime.compareAndSet(null, durationSinceCreation);
        return this.queryState.setIf(QueryState.STARTING, currentState -> currentState == QueryState.QUEUED || currentState == QueryState.PLANNING);
    }

    public boolean transitionToRunning() {
        Duration durationSinceCreation = Duration.nanosSince((long)this.createNanos).convertToMostSuccinctTimeUnit();
        this.queuedTime.compareAndSet(null, durationSinceCreation);
        this.totalPlanningTime.compareAndSet(null, durationSinceCreation);
        this.executionStartTime.compareAndSet(null, DateTime.now());
        return this.queryState.setIf(QueryState.RUNNING, currentState -> currentState != QueryState.RUNNING && currentState != QueryState.FINISHING && !currentState.isDone());
    }

    public boolean transitionToFinishing() {
        Duration durationSinceCreation = Duration.nanosSince((long)this.createNanos).convertToMostSuccinctTimeUnit();
        this.queuedTime.compareAndSet(null, durationSinceCreation);
        this.totalPlanningTime.compareAndSet(null, durationSinceCreation);
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.finishingStartNanos.compareAndSet(null, System.nanoTime());
        if (!this.queryState.setIf(QueryState.FINISHING, currentState -> currentState != QueryState.FINISHING && !currentState.isDone())) {
            return false;
        }
        if (this.autoCommit) {
            this.transactionManager.asyncCommit(this.session.getTransactionId().get()).whenComplete((value, throwable) -> {
                if (throwable == null) {
                    this.transitionToFinished();
                } else {
                    this.transitionToFailed((Throwable)throwable);
                }
            });
        } else {
            this.transitionToFinished();
        }
        return true;
    }

    private boolean transitionToFinished() {
        Duration durationSinceCreation = Duration.nanosSince((long)this.createNanos).convertToMostSuccinctTimeUnit();
        this.queuedTime.compareAndSet(null, durationSinceCreation);
        this.totalPlanningTime.compareAndSet(null, durationSinceCreation);
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.finishingStartNanos.compareAndSet(null, System.nanoTime());
        this.finishingTime.compareAndSet(null, Duration.nanosSince((long)this.finishingStartNanos.get()));
        this.endTime.compareAndSet(null, now);
        this.endNanos.compareAndSet(0L, System.nanoTime());
        return this.queryState.setIf(QueryState.FINISHED, currentState -> !currentState.isDone());
    }

    public boolean transitionToFailed(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        Duration durationSinceCreation = Duration.nanosSince((long)this.createNanos).convertToMostSuccinctTimeUnit();
        this.queuedTime.compareAndSet(null, durationSinceCreation);
        this.totalPlanningTime.compareAndSet(null, durationSinceCreation);
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.finishingStartNanos.compareAndSet(null, System.nanoTime());
        this.finishingTime.compareAndSet(null, Duration.nanosSince((long)this.finishingStartNanos.get()));
        this.endTime.compareAndSet(null, now);
        this.endNanos.compareAndSet(0L, System.nanoTime());
        this.failureCause.compareAndSet(null, Failures.toFailure(throwable));
        boolean failed = this.queryState.setIf(QueryState.FAILED, currentState -> !currentState.isDone());
        if (failed) {
            log.debug(throwable, "Query %s failed", new Object[]{this.queryId});
        } else {
            log.debug(throwable, "Failure after query %s finished", new Object[]{this.queryId});
        }
        this.session.getTransactionId().ifPresent(this.autoCommit ? this.transactionManager::asyncAbort : this.transactionManager::fail);
        return failed;
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        return this.queryState.waitForStateChange(currentState, maxWait);
    }

    public void recordHeartbeat() {
        this.lastHeartbeat.set(DateTime.now());
    }

    public void recordAnalysisTime(long analysisStart) {
        this.analysisTime.compareAndSet(null, Duration.nanosSince((long)analysisStart).convertToMostSuccinctTimeUnit());
    }

    public void recordDistributedPlanningTime(long distributedPlanningStart) {
        this.distributedPlanningTime.compareAndSet(null, Duration.nanosSince((long)distributedPlanningStart).convertToMostSuccinctTimeUnit());
    }

    private static boolean isScheduled(StageInfo rootStage) {
        if (rootStage == null) {
            return false;
        }
        return StageInfo.getAllStages(rootStage).stream().map(StageInfo::getState).allMatch(state -> state == StageState.RUNNING || state.isDone());
    }
}

