/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.BufferInfo;
import com.facebook.presto.execution.SharedBuffer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class SharedBufferInfo {
    private final SharedBuffer.BufferState state;
    private final boolean canAddBuffers;
    private final boolean canAddPages;
    private final long totalBufferedBytes;
    private final long totalBufferedPages;
    private final long totalRowsSent;
    private final long totalPagesSent;
    private final List<BufferInfo> buffers;

    @JsonCreator
    public SharedBufferInfo(@JsonProperty(value="state") SharedBuffer.BufferState state, @JsonProperty(value="canAddBuffers") boolean canAddBuffers, @JsonProperty(value="canAddPages") boolean canAddPages, @JsonProperty(value="totalBufferedBytes") long totalBufferedBytes, @JsonProperty(value="totalBufferedPages") long totalBufferedPages, @JsonProperty(value="totalRowsSent") long totalRowsSent, @JsonProperty(value="totalPagesSent") long totalPagesSent, @JsonProperty(value="buffers") List<BufferInfo> buffers) {
        this.state = state;
        this.canAddBuffers = canAddBuffers;
        this.canAddPages = canAddPages;
        this.totalBufferedBytes = totalBufferedBytes;
        this.totalBufferedPages = totalBufferedPages;
        this.totalRowsSent = totalRowsSent;
        this.totalPagesSent = totalPagesSent;
        this.buffers = ImmutableList.copyOf(buffers);
    }

    @JsonProperty
    public SharedBuffer.BufferState getState() {
        return this.state;
    }

    @JsonProperty
    public List<BufferInfo> getBuffers() {
        return this.buffers;
    }

    @JsonProperty
    public boolean isCanAddBuffers() {
        return this.canAddBuffers;
    }

    @JsonProperty
    public boolean isCanAddPages() {
        return this.canAddPages;
    }

    @JsonProperty
    public long getTotalBufferedBytes() {
        return this.totalBufferedBytes;
    }

    @JsonProperty
    public long getTotalBufferedPages() {
        return this.totalBufferedPages;
    }

    @JsonProperty
    public long getTotalRowsSent() {
        return this.totalRowsSent;
    }

    @JsonProperty
    public long getTotalPagesSent() {
        return this.totalPagesSent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedBufferInfo that = (SharedBufferInfo)o;
        return Objects.equals(this.canAddBuffers, that.canAddBuffers) && Objects.equals(this.canAddPages, that.canAddPages) && Objects.equals(this.totalBufferedBytes, that.totalBufferedBytes) && Objects.equals(this.totalBufferedPages, that.totalBufferedPages) && Objects.equals(this.totalRowsSent, that.totalRowsSent) && Objects.equals(this.totalPagesSent, that.totalPagesSent) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.buffers, that.buffers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.canAddBuffers, this.canAddPages, this.totalBufferedBytes, this.totalBufferedPages, this.totalRowsSent, this.totalPagesSent, this.buffers});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("canAddBuffers", this.canAddBuffers).add("canAddPages", this.canAddPages).add("totalBufferedBytes", this.totalBufferedBytes).add("totalBufferedPages", this.totalBufferedPages).add("totalRowsSent", this.totalRowsSent).add("totalPagesSent", this.totalPagesSent).add("buffers", this.buffers).toString();
    }
}

